package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaRebalanceBuilder extends io.strimzi.api.kafka.model.KafkaRebalanceFluentImpl<io.strimzi.api.kafka.model.KafkaRebalanceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaRebalance,io.strimzi.api.kafka.model.KafkaRebalanceBuilder> {

    io.strimzi.api.kafka.model.KafkaRebalanceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaRebalanceBuilder() {
        this(true);
    }

    public KafkaRebalanceBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaRebalance(), validationEnabled);
    }

    public KafkaRebalanceBuilder(io.strimzi.api.kafka.model.KafkaRebalanceFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaRebalanceBuilder(io.strimzi.api.kafka.model.KafkaRebalanceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaRebalance(), validationEnabled);
    }

    public KafkaRebalanceBuilder(io.strimzi.api.kafka.model.KafkaRebalanceFluent<?> fluent,io.strimzi.api.kafka.model.KafkaRebalance instance) {
        this(fluent, instance, true);
    }

    public KafkaRebalanceBuilder(io.strimzi.api.kafka.model.KafkaRebalanceFluent<?> fluent,io.strimzi.api.kafka.model.KafkaRebalance instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaRebalanceBuilder(io.strimzi.api.kafka.model.KafkaRebalance instance) {
        this(instance,true);
    }

    public KafkaRebalanceBuilder(io.strimzi.api.kafka.model.KafkaRebalance instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaRebalance build() {
        KafkaRebalance buildable = new KafkaRebalance();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaRebalanceBuilder that = (KafkaRebalanceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
