package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaRebalanceSpecBuilder extends io.strimzi.api.kafka.model.KafkaRebalanceSpecFluentImpl<io.strimzi.api.kafka.model.KafkaRebalanceSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaRebalanceSpec,io.strimzi.api.kafka.model.KafkaRebalanceSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaRebalanceSpecBuilder() {
        this(true);
    }

    public KafkaRebalanceSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaRebalanceSpec(), validationEnabled);
    }

    public KafkaRebalanceSpecBuilder(io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaRebalanceSpecBuilder(io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaRebalanceSpec(), validationEnabled);
    }

    public KafkaRebalanceSpecBuilder(io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaRebalanceSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaRebalanceSpecBuilder(io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaRebalanceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGoals(instance.getGoals());
        
        fluent.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
        
        fluent.withRebalanceDisk(instance.isRebalanceDisk());
        
        fluent.withExcludedTopics(instance.getExcludedTopics());
        
        fluent.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
        
        fluent.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
        
        fluent.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
        
        fluent.withReplicationThrottle(instance.getReplicationThrottle());
        
        fluent.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaRebalanceSpecBuilder(io.strimzi.api.kafka.model.KafkaRebalanceSpec instance) {
        this(instance,true);
    }

    public KafkaRebalanceSpecBuilder(io.strimzi.api.kafka.model.KafkaRebalanceSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withGoals(instance.getGoals());
        
        this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
        
        this.withRebalanceDisk(instance.isRebalanceDisk());
        
        this.withExcludedTopics(instance.getExcludedTopics());
        
        this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
        
        this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
        
        this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
        
        this.withReplicationThrottle(instance.getReplicationThrottle());
        
        this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaRebalanceSpec build() {
        KafkaRebalanceSpec buildable = new KafkaRebalanceSpec();
        buildable.setGoals(fluent.getGoals());
        buildable.setSkipHardGoalCheck(fluent.isSkipHardGoalCheck());
        buildable.setRebalanceDisk(fluent.isRebalanceDisk());
        buildable.setExcludedTopics(fluent.getExcludedTopics());
        buildable.setConcurrentPartitionMovementsPerBroker(fluent.getConcurrentPartitionMovementsPerBroker());
        buildable.setConcurrentIntraBrokerPartitionMovements(fluent.getConcurrentIntraBrokerPartitionMovements());
        buildable.setConcurrentLeaderMovements(fluent.getConcurrentLeaderMovements());
        buildable.setReplicationThrottle(fluent.getReplicationThrottle());
        buildable.setReplicaMovementStrategies(fluent.getReplicaMovementStrategies());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaRebalanceSpecBuilder that = (KafkaRebalanceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
