package io.strimzi.api.kafka.model;

import java.lang.Deprecated;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.function.Predicate;

public class KafkaRebalanceSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent<A> {

    private java.util.List<java.lang.String> goals;
    private boolean skipHardGoalCheck;
    private boolean rebalanceDisk;
    private java.lang.String excludedTopics;
    private int concurrentPartitionMovementsPerBroker;
    private int concurrentIntraBrokerPartitionMovements;
    private int concurrentLeaderMovements;
    private long replicationThrottle;
    private java.util.List<java.lang.String> replicaMovementStrategies;

    public KafkaRebalanceSpecFluentImpl() {
    }

    public KafkaRebalanceSpecFluentImpl(io.strimzi.api.kafka.model.KafkaRebalanceSpec instance) {
        this.withGoals(instance.getGoals());
        
        this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
        
        this.withRebalanceDisk(instance.isRebalanceDisk());
        
        this.withExcludedTopics(instance.getExcludedTopics());
        
        this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
        
        this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
        
        this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
        
        this.withReplicationThrottle(instance.getReplicationThrottle());
        
        this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
    }

    public A addToGoals(int index,java.lang.String item) {
        if (this.goals == null) {this.goals = new java.util.ArrayList<java.lang.String>();}
        this.goals.add(index, item);
        return (A)this;
    }

    public A setToGoals(int index,java.lang.String item) {
        if (this.goals == null) {this.goals = new java.util.ArrayList<java.lang.String>();}
        this.goals.set(index, item); return (A)this;
    }

    public A addToGoals(java.lang.String... items) {
        if (this.goals == null) {this.goals = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.goals.add(item);} return (A)this;
    }

    public A addAllToGoals(java.util.Collection<java.lang.String> items) {
        if (this.goals == null) {this.goals = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.goals.add(item);} return (A)this;
    }

    public A removeFromGoals(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.goals!= null){ this.goals.remove(item);}} return (A)this;
    }

    public A removeAllFromGoals(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.goals!= null){ this.goals.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getGoals() {
        return this.goals;
    }

    public java.lang.String getGoal(int index) {
        return this.goals.get(index);
    }

    public java.lang.String getFirstGoal() {
        return this.goals.get(0);
    }

    public java.lang.String getLastGoal() {
        return this.goals.get(goals.size() - 1);
    }

    public java.lang.String getMatchingGoal(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: goals) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingGoal(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: goals) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGoals(java.util.List<java.lang.String> goals) {
        if (this.goals != null) { _visitables.get("goals").removeAll(this.goals);}
        if (goals != null) {this.goals = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : goals){this.addToGoals(item);}} else { this.goals = null;} return (A) this;
    }

    public A withGoals(java.lang.String... goals) {
        if (this.goals != null) {this.goals.clear();}
        if (goals != null) {for (java.lang.String item :goals){ this.addToGoals(item);}} return (A) this;
    }

    public java.lang.Boolean hasGoals() {
        return goals != null && !goals.isEmpty();
    }

    public A addNewGoal(java.lang.String original) {
        return (A)addToGoals(new String(original));
    }

    public boolean isSkipHardGoalCheck() {
        return this.skipHardGoalCheck;
    }

    public A withSkipHardGoalCheck(boolean skipHardGoalCheck) {
        this.skipHardGoalCheck=skipHardGoalCheck; return (A) this;
    }

    public java.lang.Boolean hasSkipHardGoalCheck() {
        return true;
    }

    public boolean isRebalanceDisk() {
        return this.rebalanceDisk;
    }

    public A withRebalanceDisk(boolean rebalanceDisk) {
        this.rebalanceDisk=rebalanceDisk; return (A) this;
    }

    public java.lang.Boolean hasRebalanceDisk() {
        return true;
    }

    public java.lang.String getExcludedTopics() {
        return this.excludedTopics;
    }

    public A withExcludedTopics(java.lang.String excludedTopics) {
        this.excludedTopics=excludedTopics; return (A) this;
    }

    public java.lang.Boolean hasExcludedTopics() {
        return this.excludedTopics != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withExcludedTopics instead.
     */
        public A withNewExcludedTopics(java.lang.String original) {
        return (A)withExcludedTopics(new String(original));
    }

    public int getConcurrentPartitionMovementsPerBroker() {
        return this.concurrentPartitionMovementsPerBroker;
    }

    public A withConcurrentPartitionMovementsPerBroker(int concurrentPartitionMovementsPerBroker) {
        this.concurrentPartitionMovementsPerBroker=concurrentPartitionMovementsPerBroker; return (A) this;
    }

    public java.lang.Boolean hasConcurrentPartitionMovementsPerBroker() {
        return true;
    }

    public int getConcurrentIntraBrokerPartitionMovements() {
        return this.concurrentIntraBrokerPartitionMovements;
    }

    public A withConcurrentIntraBrokerPartitionMovements(int concurrentIntraBrokerPartitionMovements) {
        this.concurrentIntraBrokerPartitionMovements=concurrentIntraBrokerPartitionMovements; return (A) this;
    }

    public java.lang.Boolean hasConcurrentIntraBrokerPartitionMovements() {
        return true;
    }

    public int getConcurrentLeaderMovements() {
        return this.concurrentLeaderMovements;
    }

    public A withConcurrentLeaderMovements(int concurrentLeaderMovements) {
        this.concurrentLeaderMovements=concurrentLeaderMovements; return (A) this;
    }

    public java.lang.Boolean hasConcurrentLeaderMovements() {
        return true;
    }

    public long getReplicationThrottle() {
        return this.replicationThrottle;
    }

    public A withReplicationThrottle(long replicationThrottle) {
        this.replicationThrottle=replicationThrottle; return (A) this;
    }

    public java.lang.Boolean hasReplicationThrottle() {
        return true;
    }

    public A addToReplicaMovementStrategies(int index,java.lang.String item) {
        if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new java.util.ArrayList<java.lang.String>();}
        this.replicaMovementStrategies.add(index, item);
        return (A)this;
    }

    public A setToReplicaMovementStrategies(int index,java.lang.String item) {
        if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new java.util.ArrayList<java.lang.String>();}
        this.replicaMovementStrategies.set(index, item); return (A)this;
    }

    public A addToReplicaMovementStrategies(java.lang.String... items) {
        if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.replicaMovementStrategies.add(item);} return (A)this;
    }

    public A addAllToReplicaMovementStrategies(java.util.Collection<java.lang.String> items) {
        if (this.replicaMovementStrategies == null) {this.replicaMovementStrategies = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.replicaMovementStrategies.add(item);} return (A)this;
    }

    public A removeFromReplicaMovementStrategies(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.replicaMovementStrategies!= null){ this.replicaMovementStrategies.remove(item);}} return (A)this;
    }

    public A removeAllFromReplicaMovementStrategies(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.replicaMovementStrategies!= null){ this.replicaMovementStrategies.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getReplicaMovementStrategies() {
        return this.replicaMovementStrategies;
    }

    public java.lang.String getReplicaMovementStrategy(int index) {
        return this.replicaMovementStrategies.get(index);
    }

    public java.lang.String getFirstReplicaMovementStrategy() {
        return this.replicaMovementStrategies.get(0);
    }

    public java.lang.String getLastReplicaMovementStrategy() {
        return this.replicaMovementStrategies.get(replicaMovementStrategies.size() - 1);
    }

    public java.lang.String getMatchingReplicaMovementStrategy(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: replicaMovementStrategies) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingReplicaMovementStrategy(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: replicaMovementStrategies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withReplicaMovementStrategies(java.util.List<java.lang.String> replicaMovementStrategies) {
        if (this.replicaMovementStrategies != null) { _visitables.get("replicaMovementStrategies").removeAll(this.replicaMovementStrategies);}
        if (replicaMovementStrategies != null) {this.replicaMovementStrategies = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : replicaMovementStrategies){this.addToReplicaMovementStrategies(item);}} else { this.replicaMovementStrategies = null;} return (A) this;
    }

    public A withReplicaMovementStrategies(java.lang.String... replicaMovementStrategies) {
        if (this.replicaMovementStrategies != null) {this.replicaMovementStrategies.clear();}
        if (replicaMovementStrategies != null) {for (java.lang.String item :replicaMovementStrategies){ this.addToReplicaMovementStrategies(item);}} return (A) this;
    }

    public java.lang.Boolean hasReplicaMovementStrategies() {
        return replicaMovementStrategies != null && !replicaMovementStrategies.isEmpty();
    }

    public A addNewReplicaMovementStrategy(java.lang.String original) {
        return (A)addToReplicaMovementStrategies(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaRebalanceSpecFluentImpl that = (KafkaRebalanceSpecFluentImpl) o;
        if (goals != null ? !goals.equals(that.goals) :that.goals != null) return false;
        if (skipHardGoalCheck != that.skipHardGoalCheck) return false;
        if (rebalanceDisk != that.rebalanceDisk) return false;
        if (excludedTopics != null ? !excludedTopics.equals(that.excludedTopics) :that.excludedTopics != null) return false;
        if (concurrentPartitionMovementsPerBroker != that.concurrentPartitionMovementsPerBroker) return false;
        if (concurrentIntraBrokerPartitionMovements != that.concurrentIntraBrokerPartitionMovements) return false;
        if (concurrentLeaderMovements != that.concurrentLeaderMovements) return false;
        if (replicationThrottle != that.replicationThrottle) return false;
        if (replicaMovementStrategies != null ? !replicaMovementStrategies.equals(that.replicaMovementStrategies) :that.replicaMovementStrategies != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(goals,  skipHardGoalCheck,  rebalanceDisk,  excludedTopics,  concurrentPartitionMovementsPerBroker,  concurrentIntraBrokerPartitionMovements,  concurrentLeaderMovements,  replicationThrottle,  replicaMovementStrategies,  super.hashCode());
    }

}
