package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * The {@code spec} of a {@link Kafka}.
   */
  public class KafkaSpecBuilder extends io.strimzi.api.kafka.model.KafkaSpecFluentImpl<io.strimzi.api.kafka.model.KafkaSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaSpec,io.strimzi.api.kafka.model.KafkaSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaSpecBuilder() {
        this(true);
    }

    public KafkaSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaSpec(), validationEnabled);
    }

    public KafkaSpecBuilder(io.strimzi.api.kafka.model.KafkaSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaSpecBuilder(io.strimzi.api.kafka.model.KafkaSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaSpec(), validationEnabled);
    }

    public KafkaSpecBuilder(io.strimzi.api.kafka.model.KafkaSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaSpecBuilder(io.strimzi.api.kafka.model.KafkaSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withKafka(instance.getKafka());
        
        fluent.withZookeeper(instance.getZookeeper());
        
        fluent.withEntityOperator(instance.getEntityOperator());
        
        fluent.withClusterCa(instance.getClusterCa());
        
        fluent.withJmxTrans(instance.getJmxTrans());
        
        fluent.withKafkaExporter(instance.getKafkaExporter());
        
        fluent.withCruiseControl(instance.getCruiseControl());
        
        fluent.withClientsCa(instance.getClientsCa());
        
        fluent.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaSpecBuilder(io.strimzi.api.kafka.model.KafkaSpec instance) {
        this(instance,true);
    }

    public KafkaSpecBuilder(io.strimzi.api.kafka.model.KafkaSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withKafka(instance.getKafka());
        
        this.withZookeeper(instance.getZookeeper());
        
        this.withEntityOperator(instance.getEntityOperator());
        
        this.withClusterCa(instance.getClusterCa());
        
        this.withJmxTrans(instance.getJmxTrans());
        
        this.withKafkaExporter(instance.getKafkaExporter());
        
        this.withCruiseControl(instance.getCruiseControl());
        
        this.withClientsCa(instance.getClientsCa());
        
        this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaSpec build() {
        KafkaSpec buildable = new KafkaSpec();
        buildable.setKafka(fluent.getKafka());
        buildable.setZookeeper(fluent.getZookeeper());
        buildable.setEntityOperator(fluent.getEntityOperator());
        buildable.setClusterCa(fluent.getClusterCa());
        buildable.setJmxTrans(fluent.getJmxTrans());
        buildable.setKafkaExporter(fluent.getKafkaExporter());
        buildable.setCruiseControl(fluent.getCruiseControl());
        buildable.setClientsCa(fluent.getClientsCa());
        buildable.setMaintenanceTimeWindows(fluent.getMaintenanceTimeWindows());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaSpecBuilder that = (KafkaSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
