package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;

  
  /**
   * The {@code spec} of a {@link Kafka}.
   */
  public interface KafkaSpecFluent<A extends io.strimzi.api.kafka.model.KafkaSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluent<A> {


    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKafka instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaClusterSpec getKafka();
    public io.strimzi.api.kafka.model.KafkaClusterSpec buildKafka();
    public A withKafka(io.strimzi.api.kafka.model.KafkaClusterSpec kafka);
    public java.lang.Boolean hasKafka();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> withNewKafka();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> withNewKafkaLike(io.strimzi.api.kafka.model.KafkaClusterSpec item);
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> editKafka();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> editOrNewKafka();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> editOrNewKafkaLike(io.strimzi.api.kafka.model.KafkaClusterSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildZookeeper instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.ZookeeperClusterSpec getZookeeper();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpec buildZookeeper();
    public A withZookeeper(io.strimzi.api.kafka.model.ZookeeperClusterSpec zookeeper);
    public java.lang.Boolean hasZookeeper();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> withNewZookeeper();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> withNewZookeeperLike(io.strimzi.api.kafka.model.ZookeeperClusterSpec item);
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> editZookeeper();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> editOrNewZookeeper();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> editOrNewZookeeperLike(io.strimzi.api.kafka.model.ZookeeperClusterSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEntityOperator instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.EntityOperatorSpec getEntityOperator();
    public io.strimzi.api.kafka.model.EntityOperatorSpec buildEntityOperator();
    public A withEntityOperator(io.strimzi.api.kafka.model.EntityOperatorSpec entityOperator);
    public java.lang.Boolean hasEntityOperator();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> withNewEntityOperator();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> withNewEntityOperatorLike(io.strimzi.api.kafka.model.EntityOperatorSpec item);
    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> editEntityOperator();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> editOrNewEntityOperator();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> editOrNewEntityOperatorLike(io.strimzi.api.kafka.model.EntityOperatorSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClusterCa instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.CertificateAuthority getClusterCa();
    public io.strimzi.api.kafka.model.CertificateAuthority buildClusterCa();
    public A withClusterCa(io.strimzi.api.kafka.model.CertificateAuthority clusterCa);
    public java.lang.Boolean hasClusterCa();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> withNewClusterCa();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> withNewClusterCaLike(io.strimzi.api.kafka.model.CertificateAuthority item);
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> editClusterCa();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> editOrNewClusterCa();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> editOrNewClusterCaLike(io.strimzi.api.kafka.model.CertificateAuthority item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxTrans instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JmxTransSpec getJmxTrans();
    public io.strimzi.api.kafka.model.JmxTransSpec buildJmxTrans();
    public A withJmxTrans(io.strimzi.api.kafka.model.JmxTransSpec jmxTrans);
    public java.lang.Boolean hasJmxTrans();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> withNewJmxTrans();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> withNewJmxTransLike(io.strimzi.api.kafka.model.JmxTransSpec item);
    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> editJmxTrans();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> editOrNewJmxTrans();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> editOrNewJmxTransLike(io.strimzi.api.kafka.model.JmxTransSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKafkaExporter instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaExporterSpec getKafkaExporter();
    public io.strimzi.api.kafka.model.KafkaExporterSpec buildKafkaExporter();
    public A withKafkaExporter(io.strimzi.api.kafka.model.KafkaExporterSpec kafkaExporter);
    public java.lang.Boolean hasKafkaExporter();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> withNewKafkaExporter();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> withNewKafkaExporterLike(io.strimzi.api.kafka.model.KafkaExporterSpec item);
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> editKafkaExporter();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> editOrNewKafkaExporter();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> editOrNewKafkaExporterLike(io.strimzi.api.kafka.model.KafkaExporterSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCruiseControl instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.CruiseControlSpec getCruiseControl();
    public io.strimzi.api.kafka.model.CruiseControlSpec buildCruiseControl();
    public A withCruiseControl(io.strimzi.api.kafka.model.CruiseControlSpec cruiseControl);
    public java.lang.Boolean hasCruiseControl();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> withNewCruiseControl();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> withNewCruiseControlLike(io.strimzi.api.kafka.model.CruiseControlSpec item);
    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> editCruiseControl();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> editOrNewCruiseControl();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> editOrNewCruiseControlLike(io.strimzi.api.kafka.model.CruiseControlSpec item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientsCa instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.CertificateAuthority getClientsCa();
    public io.strimzi.api.kafka.model.CertificateAuthority buildClientsCa();
    public A withClientsCa(io.strimzi.api.kafka.model.CertificateAuthority clientsCa);
    public java.lang.Boolean hasClientsCa();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> withNewClientsCa();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> withNewClientsCaLike(io.strimzi.api.kafka.model.CertificateAuthority item);
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> editClientsCa();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> editOrNewClientsCa();
    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> editOrNewClientsCaLike(io.strimzi.api.kafka.model.CertificateAuthority item);
    public A addToMaintenanceTimeWindows(int index,java.lang.String item);
    public A setToMaintenanceTimeWindows(int index,java.lang.String item);
    public A addToMaintenanceTimeWindows(java.lang.String... items);
    public A addAllToMaintenanceTimeWindows(java.util.Collection<java.lang.String> items);
    public A removeFromMaintenanceTimeWindows(java.lang.String... items);
    public A removeAllFromMaintenanceTimeWindows(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getMaintenanceTimeWindows();
    public java.lang.String getMaintenanceTimeWindow(int index);
    public java.lang.String getFirstMaintenanceTimeWindow();
    public java.lang.String getLastMaintenanceTimeWindow();
    public java.lang.String getMatchingMaintenanceTimeWindow(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingMaintenanceTimeWindow(java.util.function.Predicate<java.lang.String> predicate);
    public A withMaintenanceTimeWindows(java.util.List<java.lang.String> maintenanceTimeWindows);
    public A withMaintenanceTimeWindows(java.lang.String... maintenanceTimeWindows);
    public java.lang.Boolean hasMaintenanceTimeWindows();
    public A addNewMaintenanceTimeWindow(java.lang.String original);
      
  /**
   * Representation of a Strimzi-managed Kafka "cluster".
   */
  public interface KafkaNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaClusterSpecFluent<io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<N>> {

            public N and();
            public N endKafka();    }


      
  /**
   * Representation of a Strimzi-managed ZooKeeper "cluster".
   */
  public interface ZookeeperNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<N>> {

            public N and();
            public N endZookeeper();    }


      
  /**
   * Representation of the Entity Operator deployment.
   */
  public interface EntityOperatorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.EntityOperatorSpecFluent<io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<N>> {

            public N and();
            public N endEntityOperator();    }


    public interface ClusterCaNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.CertificateAuthorityFluent<io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<N>> {

            public N and();
            public N endClusterCa();    }


      
  /**
   * Representation for options to be passed into setting up the JmxTrans.
   */
  public interface JmxTransNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.JmxTransSpecFluent<io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<N>> {

            public N and();
            public N endJmxTrans();    }


      
  /**
   * Representation of the Kafka Exporter deployment.
   */
  public interface KafkaExporterNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaExporterSpecFluent<io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<N>> {

            public N and();
            public N endKafkaExporter();    }


    public interface CruiseControlNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.CruiseControlSpecFluent<io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<N>> {

            public N and();
            public N endCruiseControl();    }


    public interface ClientsCaNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.CertificateAuthorityFluent<io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<N>> {

            public N and();
            public N endClientsCa();    }


}
