package io.strimzi.api.kafka.model;

import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

  
  /**
   * The {@code spec} of a {@link Kafka}.
   */
  public class KafkaSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.KafkaSpecFluent<A> {

    private io.strimzi.api.kafka.model.KafkaClusterSpecBuilder kafka;
    private io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder zookeeper;
    private io.strimzi.api.kafka.model.EntityOperatorSpecBuilder entityOperator;
    private io.strimzi.api.kafka.model.CertificateAuthorityBuilder clusterCa;
    private io.strimzi.api.kafka.model.JmxTransSpecBuilder jmxTrans;
    private io.strimzi.api.kafka.model.KafkaExporterSpecBuilder kafkaExporter;
    private io.strimzi.api.kafka.model.CruiseControlSpecBuilder cruiseControl;
    private io.strimzi.api.kafka.model.CertificateAuthorityBuilder clientsCa;
    private java.util.List<java.lang.String> maintenanceTimeWindows;

    public KafkaSpecFluentImpl() {
    }

    public KafkaSpecFluentImpl(io.strimzi.api.kafka.model.KafkaSpec instance) {
        this.withKafka(instance.getKafka());
        
        this.withZookeeper(instance.getZookeeper());
        
        this.withEntityOperator(instance.getEntityOperator());
        
        this.withClusterCa(instance.getClusterCa());
        
        this.withJmxTrans(instance.getJmxTrans());
        
        this.withKafkaExporter(instance.getKafkaExporter());
        
        this.withCruiseControl(instance.getCruiseControl());
        
        this.withClientsCa(instance.getClientsCa());
        
        this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKafka instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaClusterSpec getKafka() {
        return this.kafka!=null?this.kafka.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaClusterSpec buildKafka() {
        return this.kafka!=null?this.kafka.build():null;
    }

    public A withKafka(io.strimzi.api.kafka.model.KafkaClusterSpec kafka) {
        _visitables.get("kafka").remove(this.kafka);
        if (kafka!=null){ this.kafka= new io.strimzi.api.kafka.model.KafkaClusterSpecBuilder(kafka); _visitables.get("kafka").add(this.kafka);} return (A) this;
    }

    public java.lang.Boolean hasKafka() {
        return this.kafka != null;
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> withNewKafka() {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.KafkaNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> withNewKafkaLike(io.strimzi.api.kafka.model.KafkaClusterSpec item) {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.KafkaNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> editKafka() {
        return withNewKafkaLike(getKafka());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> editOrNewKafka() {
        return withNewKafkaLike(getKafka() != null ? getKafka(): new io.strimzi.api.kafka.model.KafkaClusterSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<A> editOrNewKafkaLike(io.strimzi.api.kafka.model.KafkaClusterSpec item) {
        return withNewKafkaLike(getKafka() != null ? getKafka(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildZookeeper instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.ZookeeperClusterSpec getZookeeper() {
        return this.zookeeper!=null?this.zookeeper.build():null;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpec buildZookeeper() {
        return this.zookeeper!=null?this.zookeeper.build():null;
    }

    public A withZookeeper(io.strimzi.api.kafka.model.ZookeeperClusterSpec zookeeper) {
        _visitables.get("zookeeper").remove(this.zookeeper);
        if (zookeeper!=null){ this.zookeeper= new io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder(zookeeper); _visitables.get("zookeeper").add(this.zookeeper);} return (A) this;
    }

    public java.lang.Boolean hasZookeeper() {
        return this.zookeeper != null;
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> withNewZookeeper() {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.ZookeeperNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> withNewZookeeperLike(io.strimzi.api.kafka.model.ZookeeperClusterSpec item) {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.ZookeeperNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> editZookeeper() {
        return withNewZookeeperLike(getZookeeper());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> editOrNewZookeeper() {
        return withNewZookeeperLike(getZookeeper() != null ? getZookeeper(): new io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<A> editOrNewZookeeperLike(io.strimzi.api.kafka.model.ZookeeperClusterSpec item) {
        return withNewZookeeperLike(getZookeeper() != null ? getZookeeper(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEntityOperator instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.EntityOperatorSpec getEntityOperator() {
        return this.entityOperator!=null?this.entityOperator.build():null;
    }

    public io.strimzi.api.kafka.model.EntityOperatorSpec buildEntityOperator() {
        return this.entityOperator!=null?this.entityOperator.build():null;
    }

    public A withEntityOperator(io.strimzi.api.kafka.model.EntityOperatorSpec entityOperator) {
        _visitables.get("entityOperator").remove(this.entityOperator);
        if (entityOperator!=null){ this.entityOperator= new io.strimzi.api.kafka.model.EntityOperatorSpecBuilder(entityOperator); _visitables.get("entityOperator").add(this.entityOperator);} return (A) this;
    }

    public java.lang.Boolean hasEntityOperator() {
        return this.entityOperator != null;
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> withNewEntityOperator() {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.EntityOperatorNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> withNewEntityOperatorLike(io.strimzi.api.kafka.model.EntityOperatorSpec item) {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.EntityOperatorNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> editEntityOperator() {
        return withNewEntityOperatorLike(getEntityOperator());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> editOrNewEntityOperator() {
        return withNewEntityOperatorLike(getEntityOperator() != null ? getEntityOperator(): new io.strimzi.api.kafka.model.EntityOperatorSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<A> editOrNewEntityOperatorLike(io.strimzi.api.kafka.model.EntityOperatorSpec item) {
        return withNewEntityOperatorLike(getEntityOperator() != null ? getEntityOperator(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClusterCa instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.CertificateAuthority getClusterCa() {
        return this.clusterCa!=null?this.clusterCa.build():null;
    }

    public io.strimzi.api.kafka.model.CertificateAuthority buildClusterCa() {
        return this.clusterCa!=null?this.clusterCa.build():null;
    }

    public A withClusterCa(io.strimzi.api.kafka.model.CertificateAuthority clusterCa) {
        _visitables.get("clusterCa").remove(this.clusterCa);
        if (clusterCa!=null){ this.clusterCa= new io.strimzi.api.kafka.model.CertificateAuthorityBuilder(clusterCa); _visitables.get("clusterCa").add(this.clusterCa);} return (A) this;
    }

    public java.lang.Boolean hasClusterCa() {
        return this.clusterCa != null;
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> withNewClusterCa() {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.ClusterCaNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> withNewClusterCaLike(io.strimzi.api.kafka.model.CertificateAuthority item) {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.ClusterCaNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> editClusterCa() {
        return withNewClusterCaLike(getClusterCa());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> editOrNewClusterCa() {
        return withNewClusterCaLike(getClusterCa() != null ? getClusterCa(): new io.strimzi.api.kafka.model.CertificateAuthorityBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<A> editOrNewClusterCaLike(io.strimzi.api.kafka.model.CertificateAuthority item) {
        return withNewClusterCaLike(getClusterCa() != null ? getClusterCa(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxTrans instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JmxTransSpec getJmxTrans() {
        return this.jmxTrans!=null?this.jmxTrans.build():null;
    }

    public io.strimzi.api.kafka.model.JmxTransSpec buildJmxTrans() {
        return this.jmxTrans!=null?this.jmxTrans.build():null;
    }

    public A withJmxTrans(io.strimzi.api.kafka.model.JmxTransSpec jmxTrans) {
        _visitables.get("jmxTrans").remove(this.jmxTrans);
        if (jmxTrans!=null){ this.jmxTrans= new io.strimzi.api.kafka.model.JmxTransSpecBuilder(jmxTrans); _visitables.get("jmxTrans").add(this.jmxTrans);} return (A) this;
    }

    public java.lang.Boolean hasJmxTrans() {
        return this.jmxTrans != null;
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> withNewJmxTrans() {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.JmxTransNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> withNewJmxTransLike(io.strimzi.api.kafka.model.JmxTransSpec item) {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.JmxTransNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> editJmxTrans() {
        return withNewJmxTransLike(getJmxTrans());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> editOrNewJmxTrans() {
        return withNewJmxTransLike(getJmxTrans() != null ? getJmxTrans(): new io.strimzi.api.kafka.model.JmxTransSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<A> editOrNewJmxTransLike(io.strimzi.api.kafka.model.JmxTransSpec item) {
        return withNewJmxTransLike(getJmxTrans() != null ? getJmxTrans(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKafkaExporter instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaExporterSpec getKafkaExporter() {
        return this.kafkaExporter!=null?this.kafkaExporter.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaExporterSpec buildKafkaExporter() {
        return this.kafkaExporter!=null?this.kafkaExporter.build():null;
    }

    public A withKafkaExporter(io.strimzi.api.kafka.model.KafkaExporterSpec kafkaExporter) {
        _visitables.get("kafkaExporter").remove(this.kafkaExporter);
        if (kafkaExporter!=null){ this.kafkaExporter= new io.strimzi.api.kafka.model.KafkaExporterSpecBuilder(kafkaExporter); _visitables.get("kafkaExporter").add(this.kafkaExporter);} return (A) this;
    }

    public java.lang.Boolean hasKafkaExporter() {
        return this.kafkaExporter != null;
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> withNewKafkaExporter() {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.KafkaExporterNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> withNewKafkaExporterLike(io.strimzi.api.kafka.model.KafkaExporterSpec item) {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.KafkaExporterNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> editKafkaExporter() {
        return withNewKafkaExporterLike(getKafkaExporter());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> editOrNewKafkaExporter() {
        return withNewKafkaExporterLike(getKafkaExporter() != null ? getKafkaExporter(): new io.strimzi.api.kafka.model.KafkaExporterSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<A> editOrNewKafkaExporterLike(io.strimzi.api.kafka.model.KafkaExporterSpec item) {
        return withNewKafkaExporterLike(getKafkaExporter() != null ? getKafkaExporter(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCruiseControl instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.CruiseControlSpec getCruiseControl() {
        return this.cruiseControl!=null?this.cruiseControl.build():null;
    }

    public io.strimzi.api.kafka.model.CruiseControlSpec buildCruiseControl() {
        return this.cruiseControl!=null?this.cruiseControl.build():null;
    }

    public A withCruiseControl(io.strimzi.api.kafka.model.CruiseControlSpec cruiseControl) {
        _visitables.get("cruiseControl").remove(this.cruiseControl);
        if (cruiseControl!=null){ this.cruiseControl= new io.strimzi.api.kafka.model.CruiseControlSpecBuilder(cruiseControl); _visitables.get("cruiseControl").add(this.cruiseControl);} return (A) this;
    }

    public java.lang.Boolean hasCruiseControl() {
        return this.cruiseControl != null;
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> withNewCruiseControl() {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.CruiseControlNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> withNewCruiseControlLike(io.strimzi.api.kafka.model.CruiseControlSpec item) {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.CruiseControlNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> editCruiseControl() {
        return withNewCruiseControlLike(getCruiseControl());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> editOrNewCruiseControl() {
        return withNewCruiseControlLike(getCruiseControl() != null ? getCruiseControl(): new io.strimzi.api.kafka.model.CruiseControlSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<A> editOrNewCruiseControlLike(io.strimzi.api.kafka.model.CruiseControlSpec item) {
        return withNewCruiseControlLike(getCruiseControl() != null ? getCruiseControl(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientsCa instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.CertificateAuthority getClientsCa() {
        return this.clientsCa!=null?this.clientsCa.build():null;
    }

    public io.strimzi.api.kafka.model.CertificateAuthority buildClientsCa() {
        return this.clientsCa!=null?this.clientsCa.build():null;
    }

    public A withClientsCa(io.strimzi.api.kafka.model.CertificateAuthority clientsCa) {
        _visitables.get("clientsCa").remove(this.clientsCa);
        if (clientsCa!=null){ this.clientsCa= new io.strimzi.api.kafka.model.CertificateAuthorityBuilder(clientsCa); _visitables.get("clientsCa").add(this.clientsCa);} return (A) this;
    }

    public java.lang.Boolean hasClientsCa() {
        return this.clientsCa != null;
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> withNewClientsCa() {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.ClientsCaNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> withNewClientsCaLike(io.strimzi.api.kafka.model.CertificateAuthority item) {
        return new io.strimzi.api.kafka.model.KafkaSpecFluentImpl.ClientsCaNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> editClientsCa() {
        return withNewClientsCaLike(getClientsCa());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> editOrNewClientsCa() {
        return withNewClientsCaLike(getClientsCa() != null ? getClientsCa(): new io.strimzi.api.kafka.model.CertificateAuthorityBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<A> editOrNewClientsCaLike(io.strimzi.api.kafka.model.CertificateAuthority item) {
        return withNewClientsCaLike(getClientsCa() != null ? getClientsCa(): item);
    }

    public A addToMaintenanceTimeWindows(int index,java.lang.String item) {
        if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new java.util.ArrayList<java.lang.String>();}
        this.maintenanceTimeWindows.add(index, item);
        return (A)this;
    }

    public A setToMaintenanceTimeWindows(int index,java.lang.String item) {
        if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new java.util.ArrayList<java.lang.String>();}
        this.maintenanceTimeWindows.set(index, item); return (A)this;
    }

    public A addToMaintenanceTimeWindows(java.lang.String... items) {
        if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.maintenanceTimeWindows.add(item);} return (A)this;
    }

    public A addAllToMaintenanceTimeWindows(java.util.Collection<java.lang.String> items) {
        if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.maintenanceTimeWindows.add(item);} return (A)this;
    }

    public A removeFromMaintenanceTimeWindows(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.maintenanceTimeWindows!= null){ this.maintenanceTimeWindows.remove(item);}} return (A)this;
    }

    public A removeAllFromMaintenanceTimeWindows(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.maintenanceTimeWindows!= null){ this.maintenanceTimeWindows.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getMaintenanceTimeWindows() {
        return this.maintenanceTimeWindows;
    }

    public java.lang.String getMaintenanceTimeWindow(int index) {
        return this.maintenanceTimeWindows.get(index);
    }

    public java.lang.String getFirstMaintenanceTimeWindow() {
        return this.maintenanceTimeWindows.get(0);
    }

    public java.lang.String getLastMaintenanceTimeWindow() {
        return this.maintenanceTimeWindows.get(maintenanceTimeWindows.size() - 1);
    }

    public java.lang.String getMatchingMaintenanceTimeWindow(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: maintenanceTimeWindows) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingMaintenanceTimeWindow(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: maintenanceTimeWindows) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMaintenanceTimeWindows(java.util.List<java.lang.String> maintenanceTimeWindows) {
        if (this.maintenanceTimeWindows != null) { _visitables.get("maintenanceTimeWindows").removeAll(this.maintenanceTimeWindows);}
        if (maintenanceTimeWindows != null) {this.maintenanceTimeWindows = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : maintenanceTimeWindows){this.addToMaintenanceTimeWindows(item);}} else { this.maintenanceTimeWindows = null;} return (A) this;
    }

    public A withMaintenanceTimeWindows(java.lang.String... maintenanceTimeWindows) {
        if (this.maintenanceTimeWindows != null) {this.maintenanceTimeWindows.clear();}
        if (maintenanceTimeWindows != null) {for (java.lang.String item :maintenanceTimeWindows){ this.addToMaintenanceTimeWindows(item);}} return (A) this;
    }

    public java.lang.Boolean hasMaintenanceTimeWindows() {
        return maintenanceTimeWindows != null && !maintenanceTimeWindows.isEmpty();
    }

    public A addNewMaintenanceTimeWindow(java.lang.String original) {
        return (A)addToMaintenanceTimeWindows(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaSpecFluentImpl that = (KafkaSpecFluentImpl) o;
        if (kafka != null ? !kafka.equals(that.kafka) :that.kafka != null) return false;
        if (zookeeper != null ? !zookeeper.equals(that.zookeeper) :that.zookeeper != null) return false;
        if (entityOperator != null ? !entityOperator.equals(that.entityOperator) :that.entityOperator != null) return false;
        if (clusterCa != null ? !clusterCa.equals(that.clusterCa) :that.clusterCa != null) return false;
        if (jmxTrans != null ? !jmxTrans.equals(that.jmxTrans) :that.jmxTrans != null) return false;
        if (kafkaExporter != null ? !kafkaExporter.equals(that.kafkaExporter) :that.kafkaExporter != null) return false;
        if (cruiseControl != null ? !cruiseControl.equals(that.cruiseControl) :that.cruiseControl != null) return false;
        if (clientsCa != null ? !clientsCa.equals(that.clientsCa) :that.clientsCa != null) return false;
        if (maintenanceTimeWindows != null ? !maintenanceTimeWindows.equals(that.maintenanceTimeWindows) :that.maintenanceTimeWindows != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(kafka,  zookeeper,  entityOperator,  clusterCa,  jmxTrans,  kafkaExporter,  cruiseControl,  clientsCa,  maintenanceTimeWindows,  super.hashCode());
    }

      
  /**
   * Representation of a Strimzi-managed Kafka "cluster".
   */
  public class KafkaNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaClusterSpecFluentImpl<io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<N>> implements io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaClusterSpecBuilder builder;

            KafkaNestedImpl(io.strimzi.api.kafka.model.KafkaClusterSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaClusterSpecBuilder(this, item);
                        
            }

            KafkaNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaClusterSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withKafka(builder.build());
            }

            public N endKafka() {
                return and();
            }
    }


      
  /**
   * Representation of a Strimzi-managed ZooKeeper "cluster".
   */
  public class ZookeeperNestedImpl<N> extends io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl<io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<N>> implements io.strimzi.api.kafka.model.KafkaSpecFluent.ZookeeperNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder builder;

            ZookeeperNestedImpl(io.strimzi.api.kafka.model.ZookeeperClusterSpec item) {
                this.builder = new io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder(this, item);
                        
            }

            ZookeeperNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withZookeeper(builder.build());
            }

            public N endZookeeper() {
                return and();
            }
    }


      
  /**
   * Representation of the Entity Operator deployment.
   */
  public class EntityOperatorNestedImpl<N> extends io.strimzi.api.kafka.model.EntityOperatorSpecFluentImpl<io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<N>> implements io.strimzi.api.kafka.model.KafkaSpecFluent.EntityOperatorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.EntityOperatorSpecBuilder builder;

            EntityOperatorNestedImpl(io.strimzi.api.kafka.model.EntityOperatorSpec item) {
                this.builder = new io.strimzi.api.kafka.model.EntityOperatorSpecBuilder(this, item);
                        
            }

            EntityOperatorNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.EntityOperatorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withEntityOperator(builder.build());
            }

            public N endEntityOperator() {
                return and();
            }
    }


    public class ClusterCaNestedImpl<N> extends io.strimzi.api.kafka.model.CertificateAuthorityFluentImpl<io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<N>> implements io.strimzi.api.kafka.model.KafkaSpecFluent.ClusterCaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CertificateAuthorityBuilder builder;

            ClusterCaNestedImpl(io.strimzi.api.kafka.model.CertificateAuthority item) {
                this.builder = new io.strimzi.api.kafka.model.CertificateAuthorityBuilder(this, item);
                        
            }

            ClusterCaNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.CertificateAuthorityBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withClusterCa(builder.build());
            }

            public N endClusterCa() {
                return and();
            }
    }


      
  /**
   * Representation for options to be passed into setting up the JmxTrans.
   */
  public class JmxTransNestedImpl<N> extends io.strimzi.api.kafka.model.JmxTransSpecFluentImpl<io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<N>> implements io.strimzi.api.kafka.model.KafkaSpecFluent.JmxTransNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JmxTransSpecBuilder builder;

            JmxTransNestedImpl(io.strimzi.api.kafka.model.JmxTransSpec item) {
                this.builder = new io.strimzi.api.kafka.model.JmxTransSpecBuilder(this, item);
                        
            }

            JmxTransNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JmxTransSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withJmxTrans(builder.build());
            }

            public N endJmxTrans() {
                return and();
            }
    }


      
  /**
   * Representation of the Kafka Exporter deployment.
   */
  public class KafkaExporterNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaExporterSpecFluentImpl<io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<N>> implements io.strimzi.api.kafka.model.KafkaSpecFluent.KafkaExporterNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaExporterSpecBuilder builder;

            KafkaExporterNestedImpl(io.strimzi.api.kafka.model.KafkaExporterSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaExporterSpecBuilder(this, item);
                        
            }

            KafkaExporterNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaExporterSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withKafkaExporter(builder.build());
            }

            public N endKafkaExporter() {
                return and();
            }
    }


    public class CruiseControlNestedImpl<N> extends io.strimzi.api.kafka.model.CruiseControlSpecFluentImpl<io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<N>> implements io.strimzi.api.kafka.model.KafkaSpecFluent.CruiseControlNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CruiseControlSpecBuilder builder;

            CruiseControlNestedImpl(io.strimzi.api.kafka.model.CruiseControlSpec item) {
                this.builder = new io.strimzi.api.kafka.model.CruiseControlSpecBuilder(this, item);
                        
            }

            CruiseControlNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.CruiseControlSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withCruiseControl(builder.build());
            }

            public N endCruiseControl() {
                return and();
            }
    }


    public class ClientsCaNestedImpl<N> extends io.strimzi.api.kafka.model.CertificateAuthorityFluentImpl<io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<N>> implements io.strimzi.api.kafka.model.KafkaSpecFluent.ClientsCaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CertificateAuthorityBuilder builder;

            ClientsCaNestedImpl(io.strimzi.api.kafka.model.CertificateAuthority item) {
                this.builder = new io.strimzi.api.kafka.model.CertificateAuthorityBuilder(this, item);
                        
            }

            ClientsCaNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.CertificateAuthorityBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withClientsCa(builder.build());
            }

            public N endClientsCa() {
                return and();
            }
    }


}
