package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaTopicBuilder extends io.strimzi.api.kafka.model.KafkaTopicFluentImpl<io.strimzi.api.kafka.model.KafkaTopicBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaTopic,io.strimzi.api.kafka.model.KafkaTopicBuilder> {

    io.strimzi.api.kafka.model.KafkaTopicFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaTopicBuilder() {
        this(true);
    }

    public KafkaTopicBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaTopic(), validationEnabled);
    }

    public KafkaTopicBuilder(io.strimzi.api.kafka.model.KafkaTopicFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaTopicBuilder(io.strimzi.api.kafka.model.KafkaTopicFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaTopic(), validationEnabled);
    }

    public KafkaTopicBuilder(io.strimzi.api.kafka.model.KafkaTopicFluent<?> fluent,io.strimzi.api.kafka.model.KafkaTopic instance) {
        this(fluent, instance, true);
    }

    public KafkaTopicBuilder(io.strimzi.api.kafka.model.KafkaTopicFluent<?> fluent,io.strimzi.api.kafka.model.KafkaTopic instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaTopicBuilder(io.strimzi.api.kafka.model.KafkaTopic instance) {
        this(instance,true);
    }

    public KafkaTopicBuilder(io.strimzi.api.kafka.model.KafkaTopic instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaTopic build() {
        KafkaTopic buildable = new KafkaTopic();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTopicBuilder that = (KafkaTopicBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
