package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaTopicStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaTopicStatusFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaTopicFluentImpl<A extends io.strimzi.api.kafka.model.KafkaTopicFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaTopicFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private io.strimzi.api.kafka.model.KafkaTopicSpecBuilder spec;
    private io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder status;

    public KafkaTopicFluentImpl() {
    }

    public KafkaTopicFluentImpl(io.strimzi.api.kafka.model.KafkaTopic instance) {
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String original) {
        return (A)withApiVersion(new String(original));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String original) {
        return (A)withKind(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.MetadataNested<A> withNewMetadata() {
        return new io.strimzi.api.kafka.model.KafkaTopicFluentImpl.MetadataNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.strimzi.api.kafka.model.KafkaTopicFluentImpl.MetadataNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSpec instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaTopicSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaTopicSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(io.strimzi.api.kafka.model.KafkaTopicSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new io.strimzi.api.kafka.model.KafkaTopicSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public java.lang.Boolean hasSpec() {
        return this.spec != null;
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.SpecNested<A> withNewSpec() {
        return new io.strimzi.api.kafka.model.KafkaTopicFluentImpl.SpecNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.SpecNested<A> withNewSpecLike(io.strimzi.api.kafka.model.KafkaTopicSpec item) {
        return new io.strimzi.api.kafka.model.KafkaTopicFluentImpl.SpecNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new io.strimzi.api.kafka.model.KafkaTopicSpecBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.SpecNested<A> editOrNewSpecLike(io.strimzi.api.kafka.model.KafkaTopicSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStatus instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.status.KafkaTopicStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public io.strimzi.api.kafka.model.status.KafkaTopicStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(io.strimzi.api.kafka.model.status.KafkaTopicStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public java.lang.Boolean hasStatus() {
        return this.status != null;
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.StatusNested<A> withNewStatus() {
        return new io.strimzi.api.kafka.model.KafkaTopicFluentImpl.StatusNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.StatusNested<A> withNewStatusLike(io.strimzi.api.kafka.model.status.KafkaTopicStatus item) {
        return new io.strimzi.api.kafka.model.KafkaTopicFluentImpl.StatusNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaTopicFluent.StatusNested<A> editOrNewStatusLike(io.strimzi.api.kafka.model.status.KafkaTopicStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaTopicFluentImpl that = (KafkaTopicFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.strimzi.api.kafka.model.KafkaTopicFluent.MetadataNested<N>> implements io.strimzi.api.kafka.model.KafkaTopicFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaTopicFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaTopicSpecFluentImpl<io.strimzi.api.kafka.model.KafkaTopicFluent.SpecNested<N>> implements io.strimzi.api.kafka.model.KafkaTopicFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaTopicSpecBuilder builder;

            SpecNestedImpl(io.strimzi.api.kafka.model.KafkaTopicSpec item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaTopicSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaTopicSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaTopicFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


      
  /**
   * Represents a status of the KafkaTopic resource
   */
  public class StatusNestedImpl<N> extends io.strimzi.api.kafka.model.status.KafkaTopicStatusFluentImpl<io.strimzi.api.kafka.model.KafkaTopicFluent.StatusNested<N>> implements io.strimzi.api.kafka.model.KafkaTopicFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder builder;

            StatusNestedImpl(io.strimzi.api.kafka.model.status.KafkaTopicStatus item) {
                this.builder = new io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaTopicFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
