package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaTopicSpecBuilder extends io.strimzi.api.kafka.model.KafkaTopicSpecFluentImpl<io.strimzi.api.kafka.model.KafkaTopicSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaTopicSpec,io.strimzi.api.kafka.model.KafkaTopicSpecBuilder> {

    io.strimzi.api.kafka.model.KafkaTopicSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaTopicSpecBuilder() {
        this(true);
    }

    public KafkaTopicSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaTopicSpec(), validationEnabled);
    }

    public KafkaTopicSpecBuilder(io.strimzi.api.kafka.model.KafkaTopicSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaTopicSpecBuilder(io.strimzi.api.kafka.model.KafkaTopicSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaTopicSpec(), validationEnabled);
    }

    public KafkaTopicSpecBuilder(io.strimzi.api.kafka.model.KafkaTopicSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaTopicSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaTopicSpecBuilder(io.strimzi.api.kafka.model.KafkaTopicSpecFluent<?> fluent,io.strimzi.api.kafka.model.KafkaTopicSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTopicName(instance.getTopicName());
        
        fluent.withPartitions(instance.getPartitions());
        
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaTopicSpecBuilder(io.strimzi.api.kafka.model.KafkaTopicSpec instance) {
        this(instance,true);
    }

    public KafkaTopicSpecBuilder(io.strimzi.api.kafka.model.KafkaTopicSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withTopicName(instance.getTopicName());
        
        this.withPartitions(instance.getPartitions());
        
        this.withReplicas(instance.getReplicas());
        
        this.withConfig(instance.getConfig());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaTopicSpec build() {
        KafkaTopicSpec buildable = new KafkaTopicSpec();
        buildable.setTopicName(fluent.getTopicName());
        buildable.setPartitions(fluent.getPartitions());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setConfig(fluent.getConfig());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTopicSpecBuilder that = (KafkaTopicSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
