package io.strimzi.api.kafka.model;

import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class KafkaTopicSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaTopicSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.KafkaTopicSpecFluent<A> {

    private java.lang.String topicName;
    private java.lang.Integer partitions;
    private java.lang.Integer replicas;
    private java.util.Map<java.lang.String,java.lang.Object> config;

    public KafkaTopicSpecFluentImpl() {
    }

    public KafkaTopicSpecFluentImpl(io.strimzi.api.kafka.model.KafkaTopicSpec instance) {
        this.withTopicName(instance.getTopicName());
        
        this.withPartitions(instance.getPartitions());
        
        this.withReplicas(instance.getReplicas());
        
        this.withConfig(instance.getConfig());
    }

    public java.lang.String getTopicName() {
        return this.topicName;
    }

    public A withTopicName(java.lang.String topicName) {
        this.topicName=topicName; return (A) this;
    }

    public java.lang.Boolean hasTopicName() {
        return this.topicName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTopicName instead.
     */
        public A withNewTopicName(java.lang.String original) {
        return (A)withTopicName(new String(original));
    }

    public java.lang.Integer getPartitions() {
        return this.partitions;
    }

    public A withPartitions(java.lang.Integer partitions) {
        this.partitions=partitions; return (A) this;
    }

    public java.lang.Boolean hasPartitions() {
        return this.partitions != null;
    }

    public java.lang.Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(java.lang.Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return this.replicas != null;
    }

    public A addToConfig(java.lang.String key,java.lang.Object value) {
        if(this.config == null && key != null && value != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null && map != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(java.lang.String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConfig() {
        return this.config;
    }

    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(config);} return (A) this;
    }

    public java.lang.Boolean hasConfig() {
        return this.config != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaTopicSpecFluentImpl that = (KafkaTopicSpecFluentImpl) o;
        if (topicName != null ? !topicName.equals(that.topicName) :that.topicName != null) return false;
        if (partitions != null ? !partitions.equals(that.partitions) :that.partitions != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(topicName,  partitions,  replicas,  config,  super.hashCode());
    }

}
