package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Configures the broker authorization
   */
  public class KafkaUserAuthorizationSimpleFluentImpl<A extends io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent<A> {

    private java.util.List<io.strimzi.api.kafka.model.AclRuleBuilder> acls;

    public KafkaUserAuthorizationSimpleFluentImpl() {
    }

    public KafkaUserAuthorizationSimpleFluentImpl(io.strimzi.api.kafka.model.KafkaUserAuthorizationSimple instance) {
        this.withAcls(instance.getAcls());
    }

    public A addToAcls(int index,io.strimzi.api.kafka.model.AclRule item) {
        if (this.acls == null) {this.acls = new java.util.ArrayList<io.strimzi.api.kafka.model.AclRuleBuilder>();}
        io.strimzi.api.kafka.model.AclRuleBuilder builder = new io.strimzi.api.kafka.model.AclRuleBuilder(item);_visitables.get("acls").add(index >= 0 ? index : _visitables.get("acls").size(), builder);this.acls.add(index >= 0 ? index : acls.size(), builder); return (A)this;
    }

    public A setToAcls(int index,io.strimzi.api.kafka.model.AclRule item) {
        if (this.acls == null) {this.acls = new java.util.ArrayList<io.strimzi.api.kafka.model.AclRuleBuilder>();}
        io.strimzi.api.kafka.model.AclRuleBuilder builder = new io.strimzi.api.kafka.model.AclRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("acls").size()) { _visitables.get("acls").add(builder); } else { _visitables.get("acls").set(index, builder);}
        if (index < 0 || index >= acls.size()) { acls.add(builder); } else { acls.set(index, builder);}
         return (A)this;
    }

    public A addToAcls(io.strimzi.api.kafka.model.AclRule... items) {
        if (this.acls == null) {this.acls = new java.util.ArrayList<io.strimzi.api.kafka.model.AclRuleBuilder>();}
        for (io.strimzi.api.kafka.model.AclRule item : items) {io.strimzi.api.kafka.model.AclRuleBuilder builder = new io.strimzi.api.kafka.model.AclRuleBuilder(item);_visitables.get("acls").add(builder);this.acls.add(builder);} return (A)this;
    }

    public A addAllToAcls(java.util.Collection<io.strimzi.api.kafka.model.AclRule> items) {
        if (this.acls == null) {this.acls = new java.util.ArrayList<io.strimzi.api.kafka.model.AclRuleBuilder>();}
        for (io.strimzi.api.kafka.model.AclRule item : items) {io.strimzi.api.kafka.model.AclRuleBuilder builder = new io.strimzi.api.kafka.model.AclRuleBuilder(item);_visitables.get("acls").add(builder);this.acls.add(builder);} return (A)this;
    }

    public A removeFromAcls(io.strimzi.api.kafka.model.AclRule... items) {
        for (io.strimzi.api.kafka.model.AclRule item : items) {io.strimzi.api.kafka.model.AclRuleBuilder builder = new io.strimzi.api.kafka.model.AclRuleBuilder(item);_visitables.get("acls").remove(builder);if (this.acls != null) {this.acls.remove(builder);}} return (A)this;
    }

    public A removeAllFromAcls(java.util.Collection<io.strimzi.api.kafka.model.AclRule> items) {
        for (io.strimzi.api.kafka.model.AclRule item : items) {io.strimzi.api.kafka.model.AclRuleBuilder builder = new io.strimzi.api.kafka.model.AclRuleBuilder(item);_visitables.get("acls").remove(builder);if (this.acls != null) {this.acls.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAcls(java.util.function.Predicate<io.strimzi.api.kafka.model.AclRuleBuilder> predicate) {
        if (acls == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.AclRuleBuilder> each = acls.iterator();
        final List visitables = _visitables.get("acls");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.AclRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAcls instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.AclRule> getAcls() {
        return build(acls);
    }

    public java.util.List<io.strimzi.api.kafka.model.AclRule> buildAcls() {
        return build(acls);
    }

    public io.strimzi.api.kafka.model.AclRule buildAcl(int index) {
        return this.acls.get(index).build();
    }

    public io.strimzi.api.kafka.model.AclRule buildFirstAcl() {
        return this.acls.get(0).build();
    }

    public io.strimzi.api.kafka.model.AclRule buildLastAcl() {
        return this.acls.get(acls.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.AclRule buildMatchingAcl(java.util.function.Predicate<io.strimzi.api.kafka.model.AclRuleBuilder> predicate) {
        for (io.strimzi.api.kafka.model.AclRuleBuilder item: acls) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingAcl(java.util.function.Predicate<io.strimzi.api.kafka.model.AclRuleBuilder> predicate) {
        for (io.strimzi.api.kafka.model.AclRuleBuilder item: acls) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAcls(java.util.List<io.strimzi.api.kafka.model.AclRule> acls) {
        if (this.acls != null) { _visitables.get("acls").removeAll(this.acls);}
        if (acls != null) {this.acls = new java.util.ArrayList<io.strimzi.api.kafka.model.AclRuleBuilder>(); for (io.strimzi.api.kafka.model.AclRule item : acls){this.addToAcls(item);}} else { this.acls = null;} return (A) this;
    }

    public A withAcls(io.strimzi.api.kafka.model.AclRule... acls) {
        if (this.acls != null) {this.acls.clear();}
        if (acls != null) {for (io.strimzi.api.kafka.model.AclRule item :acls){ this.addToAcls(item);}} return (A) this;
    }

    public java.lang.Boolean hasAcls() {
        return acls != null && !acls.isEmpty();
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<A> addNewAcl() {
        return new io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluentImpl.AclsNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<A> addNewAclLike(io.strimzi.api.kafka.model.AclRule item) {
        return new io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluentImpl.AclsNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<A> setNewAclLike(int index,io.strimzi.api.kafka.model.AclRule item) {
        return new io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluentImpl.AclsNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<A> editAcl(int index) {
        if (acls.size() <= index) throw new RuntimeException("Can't edit acls. Index exceeds size.");
        return setNewAclLike(index, buildAcl(index));
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<A> editFirstAcl() {
        if (acls.size() == 0) throw new RuntimeException("Can't edit first acls. The list is empty.");
        return setNewAclLike(0, buildAcl(0));
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<A> editLastAcl() {
        int index = acls.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last acls. The list is empty.");
        return setNewAclLike(index, buildAcl(index));
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<A> editMatchingAcl(java.util.function.Predicate<io.strimzi.api.kafka.model.AclRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<acls.size();i++) { 
        if (predicate.test(acls.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching acls. No match found.");
        return setNewAclLike(index, buildAcl(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaUserAuthorizationSimpleFluentImpl that = (KafkaUserAuthorizationSimpleFluentImpl) o;
        if (acls != null ? !acls.equals(that.acls) :that.acls != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(acls,  super.hashCode());
    }

      
  /**
   * A representation of a single ACL rule for AclAuthorizer
   */
  public class AclsNestedImpl<N> extends io.strimzi.api.kafka.model.AclRuleFluentImpl<io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<N>> implements io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluent.AclsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.AclRuleBuilder builder;
        private final int index;

            AclsNestedImpl(int index,io.strimzi.api.kafka.model.AclRule item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.AclRuleBuilder(this, item);
                        
            }

            AclsNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.AclRuleBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserAuthorizationSimpleFluentImpl.this.setToAcls(index,builder.build());
            }

            public N endAcl() {
                return and();
            }
    }


}
