package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserBuilder extends io.strimzi.api.kafka.model.KafkaUserFluentImpl<io.strimzi.api.kafka.model.KafkaUserBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaUser,io.strimzi.api.kafka.model.KafkaUserBuilder> {

    io.strimzi.api.kafka.model.KafkaUserFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaUserBuilder() {
        this(true);
    }

    public KafkaUserBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaUser(), validationEnabled);
    }

    public KafkaUserBuilder(io.strimzi.api.kafka.model.KafkaUserFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaUserBuilder(io.strimzi.api.kafka.model.KafkaUserFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaUser(), validationEnabled);
    }

    public KafkaUserBuilder(io.strimzi.api.kafka.model.KafkaUserFluent<?> fluent,io.strimzi.api.kafka.model.KafkaUser instance) {
        this(fluent, instance, true);
    }

    public KafkaUserBuilder(io.strimzi.api.kafka.model.KafkaUserFluent<?> fluent,io.strimzi.api.kafka.model.KafkaUser instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaUserBuilder(io.strimzi.api.kafka.model.KafkaUser instance) {
        this(instance,true);
    }

    public KafkaUserBuilder(io.strimzi.api.kafka.model.KafkaUser instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaUser build() {
        KafkaUser buildable = new KafkaUser();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaUserBuilder that = (KafkaUserBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
