package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represent the Quotas configuration for Kafka User. Kafka documentation for Kafka User quotas can be found at http://kafka.apache.org/documentation/#design_quotas
   */
  public class KafkaUserQuotasBuilder extends io.strimzi.api.kafka.model.KafkaUserQuotasFluentImpl<io.strimzi.api.kafka.model.KafkaUserQuotasBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.KafkaUserQuotas,io.strimzi.api.kafka.model.KafkaUserQuotasBuilder> {

    io.strimzi.api.kafka.model.KafkaUserQuotasFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaUserQuotasBuilder() {
        this(true);
    }

    public KafkaUserQuotasBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaUserQuotas(), validationEnabled);
    }

    public KafkaUserQuotasBuilder(io.strimzi.api.kafka.model.KafkaUserQuotasFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaUserQuotasBuilder(io.strimzi.api.kafka.model.KafkaUserQuotasFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaUserQuotas(), validationEnabled);
    }

    public KafkaUserQuotasBuilder(io.strimzi.api.kafka.model.KafkaUserQuotasFluent<?> fluent,io.strimzi.api.kafka.model.KafkaUserQuotas instance) {
        this(fluent, instance, true);
    }

    public KafkaUserQuotasBuilder(io.strimzi.api.kafka.model.KafkaUserQuotasFluent<?> fluent,io.strimzi.api.kafka.model.KafkaUserQuotas instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withProducerByteRate(instance.getProducerByteRate());
        
        fluent.withConsumerByteRate(instance.getConsumerByteRate());
        
        fluent.withRequestPercentage(instance.getRequestPercentage());
        
        fluent.withControllerMutationRate(instance.getControllerMutationRate());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaUserQuotasBuilder(io.strimzi.api.kafka.model.KafkaUserQuotas instance) {
        this(instance,true);
    }

    public KafkaUserQuotasBuilder(io.strimzi.api.kafka.model.KafkaUserQuotas instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withProducerByteRate(instance.getProducerByteRate());
        
        this.withConsumerByteRate(instance.getConsumerByteRate());
        
        this.withRequestPercentage(instance.getRequestPercentage());
        
        this.withControllerMutationRate(instance.getControllerMutationRate());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.KafkaUserQuotas build() {
        KafkaUserQuotas buildable = new KafkaUserQuotas();
        buildable.setProducerByteRate(fluent.getProducerByteRate());
        buildable.setConsumerByteRate(fluent.getConsumerByteRate());
        buildable.setRequestPercentage(fluent.getRequestPercentage());
        buildable.setControllerMutationRate(fluent.getControllerMutationRate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaUserQuotasBuilder that = (KafkaUserQuotasBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
