package io.strimzi.api.kafka.model;

import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Double;
import java.util.Map;

  
  /**
   * Represent the Quotas configuration for Kafka User. Kafka documentation for Kafka User quotas can be found at http://kafka.apache.org/documentation/#design_quotas
   */
  public interface KafkaUserQuotasFluent<A extends io.strimzi.api.kafka.model.KafkaUserQuotasFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.Integer getProducerByteRate();
    public A withProducerByteRate(java.lang.Integer producerByteRate);
    public java.lang.Boolean hasProducerByteRate();
    public java.lang.Integer getConsumerByteRate();
    public A withConsumerByteRate(java.lang.Integer consumerByteRate);
    public java.lang.Boolean hasConsumerByteRate();
    public java.lang.Integer getRequestPercentage();
    public A withRequestPercentage(java.lang.Integer requestPercentage);
    public java.lang.Boolean hasRequestPercentage();
    public java.lang.Double getControllerMutationRate();
    public A withControllerMutationRate(java.lang.Double controllerMutationRate);
    public java.lang.Boolean hasControllerMutationRate();
}
