package io.strimzi.api.kafka.model;

import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.lang.Double;

  
  /**
   * Represent the Quotas configuration for Kafka User. Kafka documentation for Kafka User quotas can be found at http://kafka.apache.org/documentation/#design_quotas
   */
  public class KafkaUserQuotasFluentImpl<A extends io.strimzi.api.kafka.model.KafkaUserQuotasFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.KafkaUserQuotasFluent<A> {

    private java.lang.Integer producerByteRate;
    private java.lang.Integer consumerByteRate;
    private java.lang.Integer requestPercentage;
    private java.lang.Double controllerMutationRate;

    public KafkaUserQuotasFluentImpl() {
    }

    public KafkaUserQuotasFluentImpl(io.strimzi.api.kafka.model.KafkaUserQuotas instance) {
        this.withProducerByteRate(instance.getProducerByteRate());
        
        this.withConsumerByteRate(instance.getConsumerByteRate());
        
        this.withRequestPercentage(instance.getRequestPercentage());
        
        this.withControllerMutationRate(instance.getControllerMutationRate());
    }

    public java.lang.Integer getProducerByteRate() {
        return this.producerByteRate;
    }

    public A withProducerByteRate(java.lang.Integer producerByteRate) {
        this.producerByteRate=producerByteRate; return (A) this;
    }

    public java.lang.Boolean hasProducerByteRate() {
        return this.producerByteRate != null;
    }

    public java.lang.Integer getConsumerByteRate() {
        return this.consumerByteRate;
    }

    public A withConsumerByteRate(java.lang.Integer consumerByteRate) {
        this.consumerByteRate=consumerByteRate; return (A) this;
    }

    public java.lang.Boolean hasConsumerByteRate() {
        return this.consumerByteRate != null;
    }

    public java.lang.Integer getRequestPercentage() {
        return this.requestPercentage;
    }

    public A withRequestPercentage(java.lang.Integer requestPercentage) {
        this.requestPercentage=requestPercentage; return (A) this;
    }

    public java.lang.Boolean hasRequestPercentage() {
        return this.requestPercentage != null;
    }

    public java.lang.Double getControllerMutationRate() {
        return this.controllerMutationRate;
    }

    public A withControllerMutationRate(java.lang.Double controllerMutationRate) {
        this.controllerMutationRate=controllerMutationRate; return (A) this;
    }

    public java.lang.Boolean hasControllerMutationRate() {
        return this.controllerMutationRate != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaUserQuotasFluentImpl that = (KafkaUserQuotasFluentImpl) o;
        if (producerByteRate != null ? !producerByteRate.equals(that.producerByteRate) :that.producerByteRate != null) return false;
        if (consumerByteRate != null ? !consumerByteRate.equals(that.consumerByteRate) :that.consumerByteRate != null) return false;
        if (requestPercentage != null ? !requestPercentage.equals(that.requestPercentage) :that.requestPercentage != null) return false;
        if (controllerMutationRate != null ? !controllerMutationRate.equals(that.controllerMutationRate) :that.controllerMutationRate != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(producerByteRate,  consumerByteRate,  requestPercentage,  controllerMutationRate,  super.hashCode());
    }

}
