package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.template.KafkaUserTemplate;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder;
import java.lang.Deprecated;
import java.lang.Boolean;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.KafkaUserTemplateFluentImpl;

public class KafkaUserSpecFluentImpl<A extends io.strimzi.api.kafka.model.KafkaUserSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.KafkaUserSpecFluent<A> {

    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.KafkaUserAuthentication,?> authentication;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.KafkaUserAuthorization,?> authorization;
    private io.strimzi.api.kafka.model.KafkaUserQuotasBuilder quotas;
    private io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder template;

    public KafkaUserSpecFluentImpl() {
    }

    public KafkaUserSpecFluentImpl(io.strimzi.api.kafka.model.KafkaUserSpec instance) {
        this.withAuthentication(instance.getAuthentication());
        
        this.withAuthorization(instance.getAuthorization());
        
        this.withQuotas(instance.getQuotas());
        
        this.withTemplate(instance.getTemplate());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthentication instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaUserAuthentication getAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthentication buildAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public A withAuthentication(io.strimzi.api.kafka.model.KafkaUserAuthentication authentication) {
        if (authentication instanceof io.strimzi.api.kafka.model.KafkaUserTlsClientAuthentication){ this.authentication= new io.strimzi.api.kafka.model.KafkaUserTlsClientAuthenticationBuilder((io.strimzi.api.kafka.model.KafkaUserTlsClientAuthentication)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthentication){ this.authentication= new io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthenticationBuilder((io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthentication)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthentication){ this.authentication= new io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthenticationBuilder((io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthentication)authentication); _visitables.get("authentication").add(this.authentication);}
        return (A) this;
    }

    public java.lang.Boolean hasAuthentication() {
        return this.authentication != null;
    }

    public A withKafkaUserTlsClientAuthentication(io.strimzi.api.kafka.model.KafkaUserTlsClientAuthentication kafkaUserTlsClientAuthentication) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaUserTlsClientAuthentication!=null){ this.authentication= new io.strimzi.api.kafka.model.KafkaUserTlsClientAuthenticationBuilder(kafkaUserTlsClientAuthentication); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserTlsClientAuthenticationNested<A> withNewKafkaUserTlsClientAuthentication() {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.KafkaUserTlsClientAuthenticationNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserTlsClientAuthenticationNested<A> withNewKafkaUserTlsClientAuthenticationLike(io.strimzi.api.kafka.model.KafkaUserTlsClientAuthentication item) {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.KafkaUserTlsClientAuthenticationNestedImpl(item);
    }

    public A withKafkaUserTlsExternalClientAuthentication(io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthentication kafkaUserTlsExternalClientAuthentication) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaUserTlsExternalClientAuthentication!=null){ this.authentication= new io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthenticationBuilder(kafkaUserTlsExternalClientAuthentication); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserTlsExternalClientAuthenticationNested<A> withNewKafkaUserTlsExternalClientAuthentication() {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.KafkaUserTlsExternalClientAuthenticationNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserTlsExternalClientAuthenticationNested<A> withNewKafkaUserTlsExternalClientAuthenticationLike(io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthentication item) {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.KafkaUserTlsExternalClientAuthenticationNestedImpl(item);
    }

    public A withKafkaUserScramSha512ClientAuthentication(io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthentication kafkaUserScramSha512ClientAuthentication) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaUserScramSha512ClientAuthentication!=null){ this.authentication= new io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthenticationBuilder(kafkaUserScramSha512ClientAuthentication); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserScramSha512ClientAuthenticationNested<A> withNewKafkaUserScramSha512ClientAuthentication() {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.KafkaUserScramSha512ClientAuthenticationNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserScramSha512ClientAuthenticationNested<A> withNewKafkaUserScramSha512ClientAuthenticationLike(io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthentication item) {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.KafkaUserScramSha512ClientAuthenticationNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuthorization instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaUserAuthorization getAuthorization() {
        return this.authorization!=null?this.authorization.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaUserAuthorization buildAuthorization() {
        return this.authorization!=null?this.authorization.build():null;
    }

    public A withAuthorization(io.strimzi.api.kafka.model.KafkaUserAuthorization authorization) {
        if (authorization instanceof io.strimzi.api.kafka.model.KafkaUserAuthorizationSimple){ this.authorization= new io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleBuilder((io.strimzi.api.kafka.model.KafkaUserAuthorizationSimple)authorization); _visitables.get("authorization").add(this.authorization);}
        return (A) this;
    }

    public java.lang.Boolean hasAuthorization() {
        return this.authorization != null;
    }

    public A withKafkaUserAuthorizationSimple(io.strimzi.api.kafka.model.KafkaUserAuthorizationSimple kafkaUserAuthorizationSimple) {
        _visitables.get("authorization").remove(this.authorization);
        if (kafkaUserAuthorizationSimple!=null){ this.authorization= new io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleBuilder(kafkaUserAuthorizationSimple); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserAuthorizationSimpleNested<A> withNewKafkaUserAuthorizationSimple() {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.KafkaUserAuthorizationSimpleNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserAuthorizationSimpleNested<A> withNewKafkaUserAuthorizationSimpleLike(io.strimzi.api.kafka.model.KafkaUserAuthorizationSimple item) {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.KafkaUserAuthorizationSimpleNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildQuotas instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaUserQuotas getQuotas() {
        return this.quotas!=null?this.quotas.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaUserQuotas buildQuotas() {
        return this.quotas!=null?this.quotas.build():null;
    }

    public A withQuotas(io.strimzi.api.kafka.model.KafkaUserQuotas quotas) {
        _visitables.get("quotas").remove(this.quotas);
        if (quotas!=null){ this.quotas= new io.strimzi.api.kafka.model.KafkaUserQuotasBuilder(quotas); _visitables.get("quotas").add(this.quotas);} return (A) this;
    }

    public java.lang.Boolean hasQuotas() {
        return this.quotas != null;
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.QuotasNested<A> withNewQuotas() {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.QuotasNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.QuotasNested<A> withNewQuotasLike(io.strimzi.api.kafka.model.KafkaUserQuotas item) {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.QuotasNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.QuotasNested<A> editQuotas() {
        return withNewQuotasLike(getQuotas());
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.QuotasNested<A> editOrNewQuotas() {
        return withNewQuotasLike(getQuotas() != null ? getQuotas(): new io.strimzi.api.kafka.model.KafkaUserQuotasBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.QuotasNested<A> editOrNewQuotasLike(io.strimzi.api.kafka.model.KafkaUserQuotas item) {
        return withNewQuotasLike(getQuotas() != null ? getQuotas(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.KafkaUserTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.KafkaUserTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.KafkaUserTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaUserTemplate item) {
        return new io.strimzi.api.kafka.model.KafkaUserSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.KafkaUserSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.KafkaUserTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaUserSpecFluentImpl that = (KafkaUserSpecFluentImpl) o;
        if (authentication != null ? !authentication.equals(that.authentication) :that.authentication != null) return false;
        if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
        if (quotas != null ? !quotas.equals(that.quotas) :that.quotas != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(authentication,  authorization,  quotas,  template,  super.hashCode());
    }

    public class KafkaUserTlsClientAuthenticationNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaUserTlsClientAuthenticationFluentImpl<io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserTlsClientAuthenticationNested<N>> implements io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserTlsClientAuthenticationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaUserTlsClientAuthenticationBuilder builder;

            KafkaUserTlsClientAuthenticationNestedImpl(io.strimzi.api.kafka.model.KafkaUserTlsClientAuthentication item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserTlsClientAuthenticationBuilder(this, item);
                        
            }

            KafkaUserTlsClientAuthenticationNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserTlsClientAuthenticationBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaUserTlsClientAuthentication() {
                return and();
            }
    }


    public class KafkaUserTlsExternalClientAuthenticationNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthenticationFluentImpl<io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserTlsExternalClientAuthenticationNested<N>> implements io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserTlsExternalClientAuthenticationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthenticationBuilder builder;

            KafkaUserTlsExternalClientAuthenticationNestedImpl(io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthentication item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthenticationBuilder(this, item);
                        
            }

            KafkaUserTlsExternalClientAuthenticationNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserTlsExternalClientAuthenticationBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaUserTlsExternalClientAuthentication() {
                return and();
            }
    }


    public class KafkaUserScramSha512ClientAuthenticationNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthenticationFluentImpl<io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserScramSha512ClientAuthenticationNested<N>> implements io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserScramSha512ClientAuthenticationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthenticationBuilder builder;

            KafkaUserScramSha512ClientAuthenticationNestedImpl(io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthentication item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthenticationBuilder(this, item);
                        
            }

            KafkaUserScramSha512ClientAuthenticationNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserScramSha512ClientAuthenticationBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaUserScramSha512ClientAuthentication() {
                return and();
            }
    }


      
  /**
   * Configures the broker authorization
   */
  public class KafkaUserAuthorizationSimpleNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleFluentImpl<io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserAuthorizationSimpleNested<N>> implements io.strimzi.api.kafka.model.KafkaUserSpecFluent.KafkaUserAuthorizationSimpleNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleBuilder builder;

            KafkaUserAuthorizationSimpleNestedImpl(io.strimzi.api.kafka.model.KafkaUserAuthorizationSimple item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleBuilder(this, item);
                        
            }

            KafkaUserAuthorizationSimpleNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserAuthorizationSimpleBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserSpecFluentImpl.this.withAuthorization(builder.build());
            }

            public N endKafkaUserAuthorizationSimple() {
                return and();
            }
    }


      
  /**
   * Represent the Quotas configuration for Kafka User. Kafka documentation for Kafka User quotas can be found at http://kafka.apache.org/documentation/#design_quotas
   */
  public class QuotasNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaUserQuotasFluentImpl<io.strimzi.api.kafka.model.KafkaUserSpecFluent.QuotasNested<N>> implements io.strimzi.api.kafka.model.KafkaUserSpecFluent.QuotasNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaUserQuotasBuilder builder;

            QuotasNestedImpl(io.strimzi.api.kafka.model.KafkaUserQuotas item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserQuotasBuilder(this, item);
                        
            }

            QuotasNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaUserQuotasBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserSpecFluentImpl.this.withQuotas(builder.build());
            }

            public N endQuotas() {
                return and();
            }
    }


      
  /**
   * Representation of a template for a KafkaUser resource.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.KafkaUserTemplateFluentImpl<io.strimzi.api.kafka.model.KafkaUserSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.KafkaUserSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.KafkaUserTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
