package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Represents a password inside a Secret
   */
  public class PasswordSecretSourceBuilder extends io.strimzi.api.kafka.model.PasswordSecretSourceFluentImpl<io.strimzi.api.kafka.model.PasswordSecretSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.PasswordSecretSource,io.strimzi.api.kafka.model.PasswordSecretSourceBuilder> {

    io.strimzi.api.kafka.model.PasswordSecretSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PasswordSecretSourceBuilder() {
        this(true);
    }

    public PasswordSecretSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new PasswordSecretSource(), validationEnabled);
    }

    public PasswordSecretSourceBuilder(io.strimzi.api.kafka.model.PasswordSecretSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public PasswordSecretSourceBuilder(io.strimzi.api.kafka.model.PasswordSecretSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PasswordSecretSource(), validationEnabled);
    }

    public PasswordSecretSourceBuilder(io.strimzi.api.kafka.model.PasswordSecretSourceFluent<?> fluent,io.strimzi.api.kafka.model.PasswordSecretSource instance) {
        this(fluent, instance, true);
    }

    public PasswordSecretSourceBuilder(io.strimzi.api.kafka.model.PasswordSecretSourceFluent<?> fluent,io.strimzi.api.kafka.model.PasswordSecretSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSecretName(instance.getSecretName());
        
        fluent.withPassword(instance.getPassword());
        
        this.validationEnabled = validationEnabled; 
    }

    public PasswordSecretSourceBuilder(io.strimzi.api.kafka.model.PasswordSecretSource instance) {
        this(instance,true);
    }

    public PasswordSecretSourceBuilder(io.strimzi.api.kafka.model.PasswordSecretSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSecretName(instance.getSecretName());
        
        this.withPassword(instance.getPassword());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.PasswordSecretSource build() {
        PasswordSecretSource buildable = new PasswordSecretSource();
        buildable.setSecretName(fluent.getSecretName());
        buildable.setPassword(fluent.getPassword());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PasswordSecretSourceBuilder that = (PasswordSecretSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
