package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Selects a source of a password field
   */
  public class PasswordSourceBuilder extends io.strimzi.api.kafka.model.PasswordSourceFluentImpl<io.strimzi.api.kafka.model.PasswordSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.PasswordSource,io.strimzi.api.kafka.model.PasswordSourceBuilder> {

    io.strimzi.api.kafka.model.PasswordSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PasswordSourceBuilder() {
        this(true);
    }

    public PasswordSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new PasswordSource(), validationEnabled);
    }

    public PasswordSourceBuilder(io.strimzi.api.kafka.model.PasswordSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public PasswordSourceBuilder(io.strimzi.api.kafka.model.PasswordSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PasswordSource(), validationEnabled);
    }

    public PasswordSourceBuilder(io.strimzi.api.kafka.model.PasswordSourceFluent<?> fluent,io.strimzi.api.kafka.model.PasswordSource instance) {
        this(fluent, instance, true);
    }

    public PasswordSourceBuilder(io.strimzi.api.kafka.model.PasswordSourceFluent<?> fluent,io.strimzi.api.kafka.model.PasswordSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSecretKeyRef(instance.getSecretKeyRef());
        
        this.validationEnabled = validationEnabled; 
    }

    public PasswordSourceBuilder(io.strimzi.api.kafka.model.PasswordSource instance) {
        this(instance,true);
    }

    public PasswordSourceBuilder(io.strimzi.api.kafka.model.PasswordSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSecretKeyRef(instance.getSecretKeyRef());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.PasswordSource build() {
        PasswordSource buildable = new PasswordSource();
        buildable.setSecretKeyRef(fluent.getSecretKeyRef());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PasswordSourceBuilder that = (PasswordSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
