package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ProbeBuilder extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.ProbeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.Probe,io.strimzi.api.kafka.model.ProbeBuilder> {

    io.strimzi.api.kafka.model.ProbeFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ProbeBuilder() {
        this(true);
    }

    public ProbeBuilder(java.lang.Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(io.strimzi.api.kafka.model.ProbeFluent<?> fluent) {
        this(fluent, true);
    }

    public ProbeBuilder(io.strimzi.api.kafka.model.ProbeFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(io.strimzi.api.kafka.model.ProbeFluent<?> fluent,io.strimzi.api.kafka.model.Probe instance) {
        this(fluent, instance, true);
    }

    public ProbeBuilder(io.strimzi.api.kafka.model.ProbeFluent<?> fluent,io.strimzi.api.kafka.model.Probe instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        
        fluent.withSuccessThreshold(instance.getSuccessThreshold());
        
        fluent.withFailureThreshold(instance.getFailureThreshold());
        
        this.validationEnabled = validationEnabled; 
    }

    public ProbeBuilder(io.strimzi.api.kafka.model.Probe instance) {
        this(instance,true);
    }

    public ProbeBuilder(io.strimzi.api.kafka.model.Probe instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withPeriodSeconds(instance.getPeriodSeconds());
        
        this.withSuccessThreshold(instance.getSuccessThreshold());
        
        this.withFailureThreshold(instance.getFailureThreshold());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.Probe build() {
        Probe buildable = new Probe(fluent.getInitialDelaySeconds(),fluent.getTimeoutSeconds());
        buildable.setPeriodSeconds(fluent.getPeriodSeconds());
        buildable.setSuccessThreshold(fluent.getSuccessThreshold());
        buildable.setFailureThreshold(fluent.getFailureThreshold());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProbeBuilder that = (ProbeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
