package io.strimzi.api.kafka.model;

import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ProbeFluentImpl<A extends io.strimzi.api.kafka.model.ProbeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.ProbeFluent<A> {

    private int initialDelaySeconds;
    private int timeoutSeconds;
    private java.lang.Integer periodSeconds;
    private java.lang.Integer successThreshold;
    private java.lang.Integer failureThreshold;

    public ProbeFluentImpl() {
    }

    public ProbeFluentImpl(io.strimzi.api.kafka.model.Probe instance) {
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withPeriodSeconds(instance.getPeriodSeconds());
        
        this.withSuccessThreshold(instance.getSuccessThreshold());
        
        this.withFailureThreshold(instance.getFailureThreshold());
    }

    public int getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public A withInitialDelaySeconds(int initialDelaySeconds) {
        this.initialDelaySeconds=initialDelaySeconds; return (A) this;
    }

    public java.lang.Boolean hasInitialDelaySeconds() {
        return true;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasTimeoutSeconds() {
        return true;
    }

    public java.lang.Integer getPeriodSeconds() {
        return this.periodSeconds;
    }

    public A withPeriodSeconds(java.lang.Integer periodSeconds) {
        this.periodSeconds=periodSeconds; return (A) this;
    }

    public java.lang.Boolean hasPeriodSeconds() {
        return this.periodSeconds != null;
    }

    public java.lang.Integer getSuccessThreshold() {
        return this.successThreshold;
    }

    public A withSuccessThreshold(java.lang.Integer successThreshold) {
        this.successThreshold=successThreshold; return (A) this;
    }

    public java.lang.Boolean hasSuccessThreshold() {
        return this.successThreshold != null;
    }

    public java.lang.Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public A withFailureThreshold(java.lang.Integer failureThreshold) {
        this.failureThreshold=failureThreshold; return (A) this;
    }

    public java.lang.Boolean hasFailureThreshold() {
        return this.failureThreshold != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProbeFluentImpl that = (ProbeFluentImpl) o;
        if (initialDelaySeconds != that.initialDelaySeconds) return false;
        if (timeoutSeconds != that.timeoutSeconds) return false;
        if (periodSeconds != null ? !periodSeconds.equals(that.periodSeconds) :that.periodSeconds != null) return false;
        if (successThreshold != null ? !successThreshold.equals(that.successThreshold) :that.successThreshold != null) return false;
        if (failureThreshold != null ? !failureThreshold.equals(that.failureThreshold) :that.failureThreshold != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(initialDelaySeconds,  timeoutSeconds,  periodSeconds,  successThreshold,  failureThreshold,  super.hashCode());
    }

}
