package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of the rack configuration.
   */
  public class RackBuilder extends io.strimzi.api.kafka.model.RackFluentImpl<io.strimzi.api.kafka.model.RackBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.Rack,io.strimzi.api.kafka.model.RackBuilder> {

    io.strimzi.api.kafka.model.RackFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RackBuilder() {
        this(true);
    }

    public RackBuilder(java.lang.Boolean validationEnabled) {
        this(new Rack(), validationEnabled);
    }

    public RackBuilder(io.strimzi.api.kafka.model.RackFluent<?> fluent) {
        this(fluent, true);
    }

    public RackBuilder(io.strimzi.api.kafka.model.RackFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Rack(), validationEnabled);
    }

    public RackBuilder(io.strimzi.api.kafka.model.RackFluent<?> fluent,io.strimzi.api.kafka.model.Rack instance) {
        this(fluent, instance, true);
    }

    public RackBuilder(io.strimzi.api.kafka.model.RackFluent<?> fluent,io.strimzi.api.kafka.model.Rack instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTopologyKey(instance.getTopologyKey()); 
        this.validationEnabled = validationEnabled; 
    }

    public RackBuilder(io.strimzi.api.kafka.model.Rack instance) {
        this(instance,true);
    }

    public RackBuilder(io.strimzi.api.kafka.model.Rack instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withTopologyKey(instance.getTopologyKey()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.Rack build() {
        Rack buildable = new Rack(fluent.getTopologyKey());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RackBuilder that = (RackBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
