package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a sidecar container configuration
   */
  public class SidecarBuilder extends io.strimzi.api.kafka.model.SidecarFluentImpl<io.strimzi.api.kafka.model.SidecarBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.Sidecar,io.strimzi.api.kafka.model.SidecarBuilder> {

    io.strimzi.api.kafka.model.SidecarFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SidecarBuilder() {
        this(true);
    }

    public SidecarBuilder(java.lang.Boolean validationEnabled) {
        this(new Sidecar(), validationEnabled);
    }

    public SidecarBuilder(io.strimzi.api.kafka.model.SidecarFluent<?> fluent) {
        this(fluent, true);
    }

    public SidecarBuilder(io.strimzi.api.kafka.model.SidecarFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Sidecar(), validationEnabled);
    }

    public SidecarBuilder(io.strimzi.api.kafka.model.SidecarFluent<?> fluent,io.strimzi.api.kafka.model.Sidecar instance) {
        this(fluent, instance, true);
    }

    public SidecarBuilder(io.strimzi.api.kafka.model.SidecarFluent<?> fluent,io.strimzi.api.kafka.model.Sidecar instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImage(instance.getImage());
        
        fluent.withResources(instance.getResources());
        
        this.validationEnabled = validationEnabled; 
    }

    public SidecarBuilder(io.strimzi.api.kafka.model.Sidecar instance) {
        this(instance,true);
    }

    public SidecarBuilder(io.strimzi.api.kafka.model.Sidecar instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.Sidecar build() {
        Sidecar buildable = new Sidecar();
        buildable.setImage(fluent.getImage());
        buildable.setResources(fluent.getResources());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SidecarBuilder that = (SidecarBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
