package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StrimziPodSetBuilder extends io.strimzi.api.kafka.model.StrimziPodSetFluentImpl<io.strimzi.api.kafka.model.StrimziPodSetBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.StrimziPodSet,io.strimzi.api.kafka.model.StrimziPodSetBuilder> {

    io.strimzi.api.kafka.model.StrimziPodSetFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public StrimziPodSetBuilder() {
        this(true);
    }

    public StrimziPodSetBuilder(java.lang.Boolean validationEnabled) {
        this(new StrimziPodSet(), validationEnabled);
    }

    public StrimziPodSetBuilder(io.strimzi.api.kafka.model.StrimziPodSetFluent<?> fluent) {
        this(fluent, true);
    }

    public StrimziPodSetBuilder(io.strimzi.api.kafka.model.StrimziPodSetFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new StrimziPodSet(), validationEnabled);
    }

    public StrimziPodSetBuilder(io.strimzi.api.kafka.model.StrimziPodSetFluent<?> fluent,io.strimzi.api.kafka.model.StrimziPodSet instance) {
        this(fluent, instance, true);
    }

    public StrimziPodSetBuilder(io.strimzi.api.kafka.model.StrimziPodSetFluent<?> fluent,io.strimzi.api.kafka.model.StrimziPodSet instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withKind(instance.getKind());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public StrimziPodSetBuilder(io.strimzi.api.kafka.model.StrimziPodSet instance) {
        this(instance,true);
    }

    public StrimziPodSetBuilder(io.strimzi.api.kafka.model.StrimziPodSet instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withKind(instance.getKind());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.StrimziPodSet build() {
        StrimziPodSet buildable = new StrimziPodSet();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StrimziPodSetBuilder that = (StrimziPodSetBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
