package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StrimziPodSetSpecBuilder extends io.strimzi.api.kafka.model.StrimziPodSetSpecFluentImpl<io.strimzi.api.kafka.model.StrimziPodSetSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.StrimziPodSetSpec,io.strimzi.api.kafka.model.StrimziPodSetSpecBuilder> {

    io.strimzi.api.kafka.model.StrimziPodSetSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public StrimziPodSetSpecBuilder() {
        this(true);
    }

    public StrimziPodSetSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new StrimziPodSetSpec(), validationEnabled);
    }

    public StrimziPodSetSpecBuilder(io.strimzi.api.kafka.model.StrimziPodSetSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public StrimziPodSetSpecBuilder(io.strimzi.api.kafka.model.StrimziPodSetSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new StrimziPodSetSpec(), validationEnabled);
    }

    public StrimziPodSetSpecBuilder(io.strimzi.api.kafka.model.StrimziPodSetSpecFluent<?> fluent,io.strimzi.api.kafka.model.StrimziPodSetSpec instance) {
        this(fluent, instance, true);
    }

    public StrimziPodSetSpecBuilder(io.strimzi.api.kafka.model.StrimziPodSetSpecFluent<?> fluent,io.strimzi.api.kafka.model.StrimziPodSetSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSelector(instance.getSelector());
        
        fluent.withPods(instance.getPods());
        
        this.validationEnabled = validationEnabled; 
    }

    public StrimziPodSetSpecBuilder(io.strimzi.api.kafka.model.StrimziPodSetSpec instance) {
        this(instance,true);
    }

    public StrimziPodSetSpecBuilder(io.strimzi.api.kafka.model.StrimziPodSetSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSelector(instance.getSelector());
        
        this.withPods(instance.getPods());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.StrimziPodSetSpec build() {
        StrimziPodSetSpec buildable = new StrimziPodSetSpec();
        buildable.setSelector(fluent.getSelector());
        buildable.setPods(fluent.getPods());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StrimziPodSetSpecBuilder that = (StrimziPodSetSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
