package io.strimzi.api.kafka.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.function.Predicate;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class StrimziPodSetSpecFluentImpl<A extends io.strimzi.api.kafka.model.StrimziPodSetSpecFluent<A>> extends io.strimzi.api.kafka.model.SpecFluentImpl<A> implements io.strimzi.api.kafka.model.StrimziPodSetSpecFluent<A> {

    private io.fabric8.kubernetes.api.model.LabelSelector selector;
    private java.util.List<java.util.Map<java.lang.String,java.lang.Object>> pods;

    public StrimziPodSetSpecFluentImpl() {
    }

    public StrimziPodSetSpecFluentImpl(io.strimzi.api.kafka.model.StrimziPodSetSpec instance) {
        this.withSelector(instance.getSelector());
        
        this.withPods(instance.getPods());
    }

    public io.fabric8.kubernetes.api.model.LabelSelector getSelector() {
        return this.selector;
    }

    public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
        this.selector=selector; return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    public A addToPods(int index,java.util.Map<java.lang.String,java.lang.Object> item) {
        if (this.pods == null) {this.pods = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>();}
        this.pods.add(index, item);
        return (A)this;
    }

    public A setToPods(int index,java.util.Map<java.lang.String,java.lang.Object> item) {
        if (this.pods == null) {this.pods = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>();}
        this.pods.set(index, item); return (A)this;
    }

    public A addToPods(java.util.Map<java.lang.String,java.lang.Object>... items) {
        if (this.pods == null) {this.pods = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>();}
        for (java.util.Map<java.lang.String,java.lang.Object> item : items) {this.pods.add(item);} return (A)this;
    }

    public A addAllToPods(java.util.Collection<java.util.Map<java.lang.String,java.lang.Object>> items) {
        if (this.pods == null) {this.pods = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>();}
        for (java.util.Map<java.lang.String,java.lang.Object> item : items) {this.pods.add(item);} return (A)this;
    }

    public A removeFromPods(java.util.Map<java.lang.String,java.lang.Object>... items) {
        for (java.util.Map<java.lang.String,java.lang.Object> item : items) {if (this.pods!= null){ this.pods.remove(item);}} return (A)this;
    }

    public A removeAllFromPods(java.util.Collection<java.util.Map<java.lang.String,java.lang.Object>> items) {
        for (java.util.Map<java.lang.String,java.lang.Object> item : items) {if (this.pods!= null){ this.pods.remove(item);}} return (A)this;
    }

    public java.util.List<java.util.Map<java.lang.String,java.lang.Object>> getPods() {
        return this.pods;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getPod(int index) {
        return this.pods.get(index);
    }

    public java.util.Map<java.lang.String,java.lang.Object> getFirstPod() {
        return this.pods.get(0);
    }

    public java.util.Map<java.lang.String,java.lang.Object> getLastPod() {
        return this.pods.get(pods.size() - 1);
    }

    public java.util.Map<java.lang.String,java.lang.Object> getMatchingPod(java.util.function.Predicate<java.util.Map<java.lang.String,java.lang.Object>> predicate) {
        for (java.util.Map<java.lang.String,java.lang.Object> item: pods) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingPod(java.util.function.Predicate<java.util.Map<java.lang.String,java.lang.Object>> predicate) {
        for (java.util.Map<java.lang.String,java.lang.Object> item: pods) { if(predicate.test(item)){ return true;} } return false;
    }

    public <K,V>A withPods(java.util.List<java.util.Map<java.lang.String,java.lang.Object>> pods) {
        if (this.pods != null) { _visitables.get("pods").removeAll(this.pods);}
        if (pods != null) {this.pods = new java.util.ArrayList<java.util.Map<java.lang.String,java.lang.Object>>(); for (java.util.Map<java.lang.String,java.lang.Object> item : pods){this.addToPods(item);}} else { this.pods = null;} return (A) this;
    }

    public A withPods(java.util.Map<java.lang.String,java.lang.Object>... pods) {
        if (this.pods != null) {this.pods.clear();}
        if (pods != null) {for (java.util.Map<java.lang.String,java.lang.Object> item :pods){ this.addToPods(item);}} return (A) this;
    }

    public java.lang.Boolean hasPods() {
        return pods != null && !pods.isEmpty();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StrimziPodSetSpecFluentImpl that = (StrimziPodSetSpecFluentImpl) o;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (pods != null ? !pods.equals(that.pods) :that.pods != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(selector,  pods,  super.hashCode());
    }

}
