package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a TLS sidecar container configuration
   */
  public class TlsSidecarBuilder extends io.strimzi.api.kafka.model.TlsSidecarFluentImpl<io.strimzi.api.kafka.model.TlsSidecarBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.TlsSidecar,io.strimzi.api.kafka.model.TlsSidecarBuilder> {

    io.strimzi.api.kafka.model.TlsSidecarFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TlsSidecarBuilder() {
        this(true);
    }

    public TlsSidecarBuilder(java.lang.Boolean validationEnabled) {
        this(new TlsSidecar(), validationEnabled);
    }

    public TlsSidecarBuilder(io.strimzi.api.kafka.model.TlsSidecarFluent<?> fluent) {
        this(fluent, true);
    }

    public TlsSidecarBuilder(io.strimzi.api.kafka.model.TlsSidecarFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TlsSidecar(), validationEnabled);
    }

    public TlsSidecarBuilder(io.strimzi.api.kafka.model.TlsSidecarFluent<?> fluent,io.strimzi.api.kafka.model.TlsSidecar instance) {
        this(fluent, instance, true);
    }

    public TlsSidecarBuilder(io.strimzi.api.kafka.model.TlsSidecarFluent<?> fluent,io.strimzi.api.kafka.model.TlsSidecar instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLogLevel(instance.getLogLevel());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withImage(instance.getImage());
        
        fluent.withResources(instance.getResources());
        
        this.validationEnabled = validationEnabled; 
    }

    public TlsSidecarBuilder(io.strimzi.api.kafka.model.TlsSidecar instance) {
        this(instance,true);
    }

    public TlsSidecarBuilder(io.strimzi.api.kafka.model.TlsSidecar instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLogLevel(instance.getLogLevel());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.TlsSidecar build() {
        TlsSidecar buildable = new TlsSidecar();
        buildable.setImage(fluent.getImage());
        buildable.setResources(fluent.getResources());
        buildable.setLogLevel(fluent.getLogLevel());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TlsSidecarBuilder that = (TlsSidecarBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
