package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a TLS sidecar container configuration
   */
  public class TlsSidecarFluentImpl<A extends io.strimzi.api.kafka.model.TlsSidecarFluent<A>> extends io.strimzi.api.kafka.model.SidecarFluentImpl<A> implements io.strimzi.api.kafka.model.TlsSidecarFluent<A> {

    private io.strimzi.api.kafka.model.TlsSidecarLogLevel logLevel;
    private io.strimzi.api.kafka.model.ProbeBuilder livenessProbe;
    private io.strimzi.api.kafka.model.ProbeBuilder readinessProbe;

    public TlsSidecarFluentImpl() {
    }

    public TlsSidecarFluentImpl(io.strimzi.api.kafka.model.TlsSidecar instance) {
        this.withLogLevel(instance.getLogLevel());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
    }

    public io.strimzi.api.kafka.model.TlsSidecarLogLevel getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(io.strimzi.api.kafka.model.TlsSidecarLogLevel logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public java.lang.Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.strimzi.api.kafka.model.TlsSidecarFluentImpl.LivenessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.TlsSidecarFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.strimzi.api.kafka.model.TlsSidecarFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.TlsSidecarFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.TlsSidecarFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TlsSidecarFluentImpl that = (TlsSidecarFluentImpl) o;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(logLevel,  livenessProbe,  readinessProbe,  super.hashCode());
    }

      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class LivenessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.TlsSidecarFluent.LivenessProbeNested<N>> implements io.strimzi.api.kafka.model.TlsSidecarFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) TlsSidecarFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ReadinessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.TlsSidecarFluent.ReadinessProbeNested<N>> implements io.strimzi.api.kafka.model.TlsSidecarFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) TlsSidecarFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


}
