package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a Strimzi-managed ZooKeeper "cluster".
   */
  public class ZookeeperClusterSpecBuilder extends io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.ZookeeperClusterSpec,io.strimzi.api.kafka.model.ZookeeperClusterSpecBuilder> {

    io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ZookeeperClusterSpecBuilder() {
        this(true);
    }

    public ZookeeperClusterSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new ZookeeperClusterSpec(), validationEnabled);
    }

    public ZookeeperClusterSpecBuilder(io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ZookeeperClusterSpecBuilder(io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ZookeeperClusterSpec(), validationEnabled);
    }

    public ZookeeperClusterSpecBuilder(io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<?> fluent,io.strimzi.api.kafka.model.ZookeeperClusterSpec instance) {
        this(fluent, instance, true);
    }

    public ZookeeperClusterSpecBuilder(io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<?> fluent,io.strimzi.api.kafka.model.ZookeeperClusterSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStorage(instance.getStorage());
        
        fluent.withConfig(instance.getConfig());
        
        fluent.withLogging(instance.getLogging());
        
        fluent.withReplicas(instance.getReplicas());
        
        fluent.withImage(instance.getImage());
        
        fluent.withResources(instance.getResources());
        
        fluent.withLivenessProbe(instance.getLivenessProbe());
        
        fluent.withReadinessProbe(instance.getReadinessProbe());
        
        fluent.withJvmOptions(instance.getJvmOptions());
        
        fluent.withJmxOptions(instance.getJmxOptions());
        
        fluent.withMetricsConfig(instance.getMetricsConfig());
        
        fluent.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public ZookeeperClusterSpecBuilder(io.strimzi.api.kafka.model.ZookeeperClusterSpec instance) {
        this(instance,true);
    }

    public ZookeeperClusterSpecBuilder(io.strimzi.api.kafka.model.ZookeeperClusterSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withStorage(instance.getStorage());
        
        this.withConfig(instance.getConfig());
        
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withTemplate(instance.getTemplate());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpec build() {
        ZookeeperClusterSpec buildable = new ZookeeperClusterSpec();
        buildable.setStorage(fluent.getStorage());
        buildable.setConfig(fluent.getConfig());
        buildable.setLogging(fluent.getLogging());
        buildable.setReplicas(fluent.getReplicas());
        buildable.setImage(fluent.getImage());
        buildable.setResources(fluent.getResources());
        buildable.setLivenessProbe(fluent.getLivenessProbe());
        buildable.setReadinessProbe(fluent.getReadinessProbe());
        buildable.setJvmOptions(fluent.getJvmOptions());
        buildable.setJmxOptions(fluent.getJmxOptions());
        buildable.setMetricsConfig(fluent.getMetricsConfig());
        buildable.setTemplate(fluent.getTemplate());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ZookeeperClusterSpecBuilder that = (ZookeeperClusterSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
