package io.strimzi.api.kafka.model;

import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluent;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent;

  
  /**
   * Representation of a Strimzi-managed ZooKeeper "cluster".
   */
  public interface ZookeeperClusterSpecFluent<A extends io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStorage instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.storage.SingleVolumeStorage getStorage();
    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildStorage();
    public A withStorage(io.strimzi.api.kafka.model.storage.SingleVolumeStorage storage);
    public java.lang.Boolean hasStorage();
    public A withPersistentClaimStorage(io.strimzi.api.kafka.model.storage.PersistentClaimStorage persistentClaimStorage);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorage();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(io.strimzi.api.kafka.model.storage.PersistentClaimStorage item);
    public A withEphemeralStorage(io.strimzi.api.kafka.model.storage.EphemeralStorage ephemeralStorage);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorage();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorageLike(io.strimzi.api.kafka.model.storage.EphemeralStorage item);
    public A addToConfig(java.lang.String key,java.lang.Object value);
    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public A removeFromConfig(java.lang.String key);
    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map);
    public java.util.Map<java.lang.String,java.lang.Object> getConfig();
    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config);
    public java.lang.Boolean hasConfig();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging();
    public io.strimzi.api.kafka.model.Logging buildLogging();
    public A withLogging(io.strimzi.api.kafka.model.Logging logging);
    public java.lang.Boolean hasLogging();
    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item);
    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item);
    public int getReplicas();
    public A withReplicas(int replicas);
    public java.lang.Boolean hasReplicas();
    public java.lang.String getImage();
    public A withImage(java.lang.String image);
    public java.lang.Boolean hasImage();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original);
    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources();
    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources);
    public java.lang.Boolean hasResources();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe();
    public io.strimzi.api.kafka.model.Probe buildLivenessProbe();
    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe);
    public java.lang.Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe();
    public io.strimzi.api.kafka.model.Probe buildReadinessProbe();
    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe);
    public java.lang.Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions();
    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions();
    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions);
    public java.lang.Boolean hasJvmOptions();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaJmxOptions getJmxOptions();
    public io.strimzi.api.kafka.model.KafkaJmxOptions buildJmxOptions();
    public A withJmxOptions(io.strimzi.api.kafka.model.KafkaJmxOptions jmxOptions);
    public java.lang.Boolean hasJmxOptions();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptions();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> editJmxOptions();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptions();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricsConfig instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.MetricsConfig getMetricsConfig();
    public io.strimzi.api.kafka.model.MetricsConfig buildMetricsConfig();
    public A withMetricsConfig(io.strimzi.api.kafka.model.MetricsConfig metricsConfig);
    public java.lang.Boolean hasMetricsConfig();
    public A withJmxPrometheusExporterMetricsConfig(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate getTemplate();
    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate buildTemplate();
    public A withTemplate(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate template);
    public java.lang.Boolean hasTemplate();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> withNewTemplate();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate item);
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> editTemplate();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate item);
      
  /**
   * Representation for persistent claim-based storage.
   */
  public interface PersistentClaimStorageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.PersistentClaimStorageNested<N>> {

            public N and();
            public N endPersistentClaimStorage();    }


      
  /**
   * Representation for ephemeral storage.
   */
  public interface EphemeralStorageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.storage.EphemeralStorageFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.EphemeralStorageNested<N>> {

            public N and();
            public N endEphemeralStorage();    }


      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ExternalLoggingFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ExternalLoggingNested<N>> {

            public N and();
            public N endExternalLogging();    }


      
  /**
   * Logging config is given inline with the resource
   */
  public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.InlineLoggingFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.InlineLoggingNested<N>> {

            public N and();
            public N endInlineLogging();    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ProbeFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<N>> {

            public N and();
            public N endLivenessProbe();    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.ProbeFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<N>> {

            public N and();
            public N endReadinessProbe();    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.JvmOptionsFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<N>> {

            public N and();
            public N endJvmOptions();    }


    public interface JmxOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.KafkaJmxOptionsFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<N>> {

            public N and();
            public N endJmxOptions();    }


      
  /**
   * JMX Prometheus Exporter metrics config
   */
  public interface JmxPrometheusExporterMetricsConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> {

            public N and();
            public N endJmxPrometheusExporterMetricsConfig();    }


      
  /**
   * Representation of a template for ZooKeeper cluster resources.
   */
  public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


}
