package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.String;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import java.lang.Object;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate;
import io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl;

  
  /**
   * Representation of a Strimzi-managed ZooKeeper "cluster".
   */
  public class ZookeeperClusterSpecFluentImpl<A extends io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent<A> {

    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> storage;
    private java.util.Map<java.lang.String,java.lang.Object> config;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.Logging,?> logging;
    private int replicas;
    private java.lang.String image;
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    private io.strimzi.api.kafka.model.ProbeBuilder livenessProbe;
    private io.strimzi.api.kafka.model.ProbeBuilder readinessProbe;
    private io.strimzi.api.kafka.model.JvmOptionsBuilder jvmOptions;
    private io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder jmxOptions;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.MetricsConfig,?> metricsConfig;
    private io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder template;

    public ZookeeperClusterSpecFluentImpl() {
    }

    public ZookeeperClusterSpecFluentImpl(io.strimzi.api.kafka.model.ZookeeperClusterSpec instance) {
        this.withStorage(instance.getStorage());
        
        this.withConfig(instance.getConfig());
        
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withTemplate(instance.getTemplate());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStorage instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.storage.SingleVolumeStorage getStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public A withStorage(io.strimzi.api.kafka.model.storage.SingleVolumeStorage storage) {
        if (storage instanceof io.strimzi.api.kafka.model.storage.PersistentClaimStorage){ this.storage= new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder((io.strimzi.api.kafka.model.storage.PersistentClaimStorage)storage); _visitables.get("storage").add(this.storage);}
        if (storage instanceof io.strimzi.api.kafka.model.storage.EphemeralStorage){ this.storage= new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder((io.strimzi.api.kafka.model.storage.EphemeralStorage)storage); _visitables.get("storage").add(this.storage);}
        return (A) this;
    }

    public java.lang.Boolean hasStorage() {
        return this.storage != null;
    }

    public A withPersistentClaimStorage(io.strimzi.api.kafka.model.storage.PersistentClaimStorage persistentClaimStorage) {
        _visitables.get("storage").remove(this.storage);
        if (persistentClaimStorage!=null){ this.storage= new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(persistentClaimStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorage() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.PersistentClaimStorageNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.PersistentClaimStorageNested<A> withNewPersistentClaimStorageLike(io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.PersistentClaimStorageNestedImpl(item);
    }

    public A withEphemeralStorage(io.strimzi.api.kafka.model.storage.EphemeralStorage ephemeralStorage) {
        _visitables.get("storage").remove(this.storage);
        if (ephemeralStorage!=null){ this.storage= new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(ephemeralStorage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorage() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.EphemeralStorageNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.EphemeralStorageNested<A> withNewEphemeralStorageLike(io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.EphemeralStorageNestedImpl(item);
    }

    public A addToConfig(java.lang.String key,java.lang.Object value) {
        if(this.config == null && key != null && value != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null && map != null) { this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(java.lang.String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(java.util.Map<java.lang.String,java.lang.Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.Object> getConfig() {
        return this.config;
    }

    public <K,V>A withConfig(java.util.Map<java.lang.String,java.lang.Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(config);} return (A) this;
    }

    public java.lang.Boolean hasConfig() {
        return this.config != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLogging instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Logging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public io.strimzi.api.kafka.model.Logging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(io.strimzi.api.kafka.model.Logging logging) {
        if (logging instanceof io.strimzi.api.kafka.model.ExternalLogging){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder((io.strimzi.api.kafka.model.ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
        if (logging instanceof io.strimzi.api.kafka.model.InlineLogging){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder((io.strimzi.api.kafka.model.InlineLogging)logging); _visitables.get("logging").add(this.logging);}
        return (A) this;
    }

    public java.lang.Boolean hasLogging() {
        return this.logging != null;
    }

    public A withExternalLogging(io.strimzi.api.kafka.model.ExternalLogging externalLogging) {
        _visitables.get("logging").remove(this.logging);
        if (externalLogging!=null){ this.logging= new io.strimzi.api.kafka.model.ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.ExternalLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(io.strimzi.api.kafka.model.ExternalLogging item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(io.strimzi.api.kafka.model.InlineLogging inlineLogging) {
        _visitables.get("logging").remove(this.logging);
        if (inlineLogging!=null){ this.logging= new io.strimzi.api.kafka.model.InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.InlineLoggingNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(io.strimzi.api.kafka.model.InlineLogging item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.InlineLoggingNestedImpl(item);
    }

    public int getReplicas() {
        return this.replicas;
    }

    public A withReplicas(int replicas) {
        this.replicas=replicas; return (A) this;
    }

    public java.lang.Boolean hasReplicas() {
        return true;
    }

    public java.lang.String getImage() {
        return this.image;
    }

    public A withImage(java.lang.String image) {
        this.image=image; return (A) this;
    }

    public java.lang.Boolean hasImage() {
        return this.image != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withImage instead.
     */
        public A withNewImage(java.lang.String original) {
        return (A)withImage(new String(original));
    }

    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public java.lang.Boolean hasResources() {
        return this.resources != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildLivenessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(io.strimzi.api.kafka.model.Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public java.lang.Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.LivenessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.LivenessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildReadinessProbe instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public io.strimzi.api.kafka.model.Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(io.strimzi.api.kafka.model.Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new io.strimzi.api.kafka.model.ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public java.lang.Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.ReadinessProbeNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.ReadinessProbeNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new io.strimzi.api.kafka.model.ProbeBuilder().build());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(io.strimzi.api.kafka.model.Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJvmOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.JvmOptions getJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public io.strimzi.api.kafka.model.JvmOptions buildJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(io.strimzi.api.kafka.model.JvmOptions jvmOptions) {
        _visitables.get("jvmOptions").remove(this.jvmOptions);
        if (jvmOptions!=null){ this.jvmOptions= new io.strimzi.api.kafka.model.JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public java.lang.Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.JvmOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.JvmOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new io.strimzi.api.kafka.model.JvmOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(io.strimzi.api.kafka.model.JvmOptions item) {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxOptions instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.KafkaJmxOptions getJmxOptions() {
        return this.jmxOptions!=null?this.jmxOptions.build():null;
    }

    public io.strimzi.api.kafka.model.KafkaJmxOptions buildJmxOptions() {
        return this.jmxOptions!=null?this.jmxOptions.build():null;
    }

    public A withJmxOptions(io.strimzi.api.kafka.model.KafkaJmxOptions jmxOptions) {
        _visitables.get("jmxOptions").remove(this.jmxOptions);
        if (jmxOptions!=null){ this.jmxOptions= new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(jmxOptions); _visitables.get("jmxOptions").add(this.jmxOptions);} return (A) this;
    }

    public java.lang.Boolean hasJmxOptions() {
        return this.jmxOptions != null;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptions() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.JmxOptionsNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> withNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.JmxOptionsNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> editJmxOptions() {
        return withNewJmxOptionsLike(getJmxOptions());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptions() {
        return withNewJmxOptionsLike(getJmxOptions() != null ? getJmxOptions(): new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder().build());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<A> editOrNewJmxOptionsLike(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
        return withNewJmxOptionsLike(getJmxOptions() != null ? getJmxOptions(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricsConfig instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.MetricsConfig getMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public io.strimzi.api.kafka.model.MetricsConfig buildMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(io.strimzi.api.kafka.model.MetricsConfig metricsConfig) {
        if (metricsConfig instanceof io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder((io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
        return (A) this;
    }

    public java.lang.Boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig) {
        _visitables.get("metricsConfig").remove(this.metricsConfig);
        if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTemplate instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public java.lang.Boolean hasTemplate() {
        return this.template != null;
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> withNewTemplate() {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.TemplateNestedImpl();
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> withNewTemplateLike(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate item) {
        return new io.strimzi.api.kafka.model.ZookeeperClusterSpecFluentImpl.TemplateNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ZookeeperClusterSpecFluentImpl that = (ZookeeperClusterSpecFluentImpl) o;
        if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (replicas != that.replicas) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
        if (jmxOptions != null ? !jmxOptions.equals(that.jmxOptions) :that.jmxOptions != null) return false;
        if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(storage,  config,  logging,  replicas,  image,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  jmxOptions,  metricsConfig,  template,  super.hashCode());
    }

      
  /**
   * Representation for persistent claim-based storage.
   */
  public class PersistentClaimStorageNestedImpl<N> extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.PersistentClaimStorageNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.PersistentClaimStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder;

            PersistentClaimStorageNestedImpl(io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
                this.builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(this, item);
                        
            }

            PersistentClaimStorageNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withStorage(builder.build());
            }

            public N endPersistentClaimStorage() {
                return and();
            }
    }


      
  /**
   * Representation for ephemeral storage.
   */
  public class EphemeralStorageNestedImpl<N> extends io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.EphemeralStorageNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.EphemeralStorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder;

            EphemeralStorageNestedImpl(io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
                this.builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(this, item);
                        
            }

            EphemeralStorageNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withStorage(builder.build());
            }

            public N endEphemeralStorage() {
                return and();
            }
    }


      
  /**
   * Logging config comes from an existing, user-supplied config map
   */
  public class ExternalLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.ExternalLoggingFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ExternalLoggingNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ExternalLoggingBuilder builder;

            ExternalLoggingNestedImpl(io.strimzi.api.kafka.model.ExternalLogging item) {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this, item);
                        
            }

            ExternalLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ExternalLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endExternalLogging() {
                return and();
            }
    }


      
  /**
   * Logging config is given inline with the resource
   */
  public class InlineLoggingNestedImpl<N> extends io.strimzi.api.kafka.model.InlineLoggingFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.InlineLoggingNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.InlineLoggingBuilder builder;

            InlineLoggingNestedImpl(io.strimzi.api.kafka.model.InlineLogging item) {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this, item);
                        
            }

            InlineLoggingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.InlineLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endInlineLogging() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class LivenessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            LivenessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


      
  /**
   * A representation of the configurable aspect of a probe (used for health checks).
   */
  public class ReadinessProbeNestedImpl<N> extends io.strimzi.api.kafka.model.ProbeFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ProbeBuilder builder;

            ReadinessProbeNestedImpl(io.strimzi.api.kafka.model.Probe item) {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


      
  /**
   * Representation for options to be passed to a JVM.
   */
  public class JvmOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.JvmOptionsFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JvmOptionsBuilder builder;

            JvmOptionsNestedImpl(io.strimzi.api.kafka.model.JvmOptions item) {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this, item);
                        
            }

            JvmOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JvmOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withJvmOptions(builder.build());
            }

            public N endJvmOptions() {
                return and();
            }
    }


    public class JmxOptionsNestedImpl<N> extends io.strimzi.api.kafka.model.KafkaJmxOptionsFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder builder;

            JmxOptionsNestedImpl(io.strimzi.api.kafka.model.KafkaJmxOptions item) {
                this.builder = new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(this, item);
                        
            }

            JmxOptionsNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.KafkaJmxOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withJmxOptions(builder.build());
            }

            public N endJmxOptions() {
                return and();
            }
    }


      
  /**
   * JMX Prometheus Exporter metrics config
   */
  public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder builder;

            JmxPrometheusExporterMetricsConfigNestedImpl(io.strimzi.api.kafka.model.JmxPrometheusExporterMetrics item) {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this, item);
                        
            }

            JmxPrometheusExporterMetricsConfigNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withMetricsConfig(builder.build());
            }

            public N endJmxPrometheusExporterMetricsConfig() {
                return and();
            }
    }


      
  /**
   * Representation of a template for ZooKeeper cluster resources.
   */
  public class TemplateNestedImpl<N> extends io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl<io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<N>> implements io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder builder;

            TemplateNestedImpl(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


}
