package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the Kafka client authentication using SASl OAUTHBEARER mechanism in client based components
   */
  public class KafkaClientAuthenticationOAuthBuilder extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder> {

    io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaClientAuthenticationOAuthBuilder() {
        this(true);
    }

    public KafkaClientAuthenticationOAuthBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaClientAuthenticationOAuth(), validationEnabled);
    }

    public KafkaClientAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaClientAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaClientAuthenticationOAuth(), validationEnabled);
    }

    public KafkaClientAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth instance) {
        this(fluent, instance, true);
    }

    public KafkaClientAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withClientId(instance.getClientId());
        
        fluent.withScope(instance.getScope());
        
        fluent.withAudience(instance.getAudience());
        
        fluent.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        fluent.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        fluent.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        fluent.withClientSecret(instance.getClientSecret());
        
        fluent.withAccessToken(instance.getAccessToken());
        
        fluent.withRefreshToken(instance.getRefreshToken());
        
        fluent.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        fluent.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        fluent.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
        
        fluent.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth instance) {
        this(instance,true);
    }

    public KafkaClientAuthenticationOAuthBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withClientId(instance.getClientId());
        
        this.withScope(instance.getScope());
        
        this.withAudience(instance.getAudience());
        
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        this.withClientSecret(instance.getClientSecret());
        
        this.withAccessToken(instance.getAccessToken());
        
        this.withRefreshToken(instance.getRefreshToken());
        
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
        
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth build() {
        KafkaClientAuthenticationOAuth buildable = new KafkaClientAuthenticationOAuth();
        buildable.setClientId(fluent.getClientId());
        buildable.setScope(fluent.getScope());
        buildable.setAudience(fluent.getAudience());
        buildable.setTokenEndpointUri(fluent.getTokenEndpointUri());
        buildable.setConnectTimeoutSeconds(fluent.getConnectTimeoutSeconds());
        buildable.setReadTimeoutSeconds(fluent.getReadTimeoutSeconds());
        buildable.setClientSecret(fluent.getClientSecret());
        buildable.setAccessToken(fluent.getAccessToken());
        buildable.setRefreshToken(fluent.getRefreshToken());
        buildable.setTlsTrustedCertificates(fluent.getTlsTrustedCertificates());
        buildable.setDisableTlsHostnameVerification(fluent.isDisableTlsHostnameVerification());
        buildable.setMaxTokenExpirySeconds(fluent.getMaxTokenExpirySeconds());
        buildable.setAccessTokenIsJwt(fluent.isAccessTokenIsJwt());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaClientAuthenticationOAuthBuilder that = (KafkaClientAuthenticationOAuthBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
