package io.strimzi.api.kafka.model.authentication;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.GenericSecretSourceFluent;
import java.lang.Integer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluent;
import java.util.Collection;
import io.strimzi.api.kafka.model.CertSecretSource;

  
  /**
   * Configures the Kafka client authentication using SASl OAUTHBEARER mechanism in client based components
   */
  public interface KafkaClientAuthenticationOAuthFluent<A extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getClientId();
    public A withClientId(java.lang.String clientId);
    public java.lang.Boolean hasClientId();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientId instead.
     */
        public A withNewClientId(java.lang.String original);
    public java.lang.String getScope();
    public A withScope(java.lang.String scope);
    public java.lang.Boolean hasScope();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withScope instead.
     */
        public A withNewScope(java.lang.String original);
    public java.lang.String getAudience();
    public A withAudience(java.lang.String audience);
    public java.lang.Boolean hasAudience();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAudience instead.
     */
        public A withNewAudience(java.lang.String original);
    public java.lang.String getTokenEndpointUri();
    public A withTokenEndpointUri(java.lang.String tokenEndpointUri);
    public java.lang.Boolean hasTokenEndpointUri();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTokenEndpointUri instead.
     */
        public A withNewTokenEndpointUri(java.lang.String original);
    public java.lang.Integer getConnectTimeoutSeconds();
    public A withConnectTimeoutSeconds(java.lang.Integer connectTimeoutSeconds);
    public java.lang.Boolean hasConnectTimeoutSeconds();
    public java.lang.Integer getReadTimeoutSeconds();
    public A withReadTimeoutSeconds(java.lang.Integer readTimeoutSeconds);
    public java.lang.Boolean hasReadTimeoutSeconds();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.GenericSecretSource getClientSecret();
    public io.strimzi.api.kafka.model.GenericSecretSource buildClientSecret();
    public A withClientSecret(io.strimzi.api.kafka.model.GenericSecretSource clientSecret);
    public java.lang.Boolean hasClientSecret();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAccessToken instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.GenericSecretSource getAccessToken();
    public io.strimzi.api.kafka.model.GenericSecretSource buildAccessToken();
    public A withAccessToken(io.strimzi.api.kafka.model.GenericSecretSource accessToken);
    public java.lang.Boolean hasAccessToken();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessToken();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessTokenLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editAccessToken();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessToken();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessTokenLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRefreshToken instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.GenericSecretSource getRefreshToken();
    public io.strimzi.api.kafka.model.GenericSecretSource buildRefreshToken();
    public A withRefreshToken(io.strimzi.api.kafka.model.GenericSecretSource refreshToken);
    public java.lang.Boolean hasRefreshToken();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshToken();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshTokenLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editRefreshToken();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshToken();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshTokenLike(io.strimzi.api.kafka.model.GenericSecretSource item);
    public A addToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public A setToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items);
    public A addAllToTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items);
    public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items);
    public A removeAllFromTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items);
    public A removeMatchingFromTlsTrustedCertificates(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> getTlsTrustedCertificates();
    public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> buildTlsTrustedCertificates();
    public io.strimzi.api.kafka.model.CertSecretSource buildTlsTrustedCertificate(int index);
    public io.strimzi.api.kafka.model.CertSecretSource buildFirstTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.CertSecretSource buildLastTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.CertSecretSource buildMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public java.lang.Boolean hasMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public A withTlsTrustedCertificates(java.util.List<io.strimzi.api.kafka.model.CertSecretSource> tlsTrustedCertificates);
    public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... tlsTrustedCertificates);
    public java.lang.Boolean hasTlsTrustedCertificates();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(io.strimzi.api.kafka.model.CertSecretSource item);
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,io.strimzi.api.kafka.model.CertSecretSource item);
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index);
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate();
    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate);
    public boolean isDisableTlsHostnameVerification();
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification);
    public java.lang.Boolean hasDisableTlsHostnameVerification();
    public int getMaxTokenExpirySeconds();
    public A withMaxTokenExpirySeconds(int maxTokenExpirySeconds);
    public java.lang.Boolean hasMaxTokenExpirySeconds();
    public boolean isAccessTokenIsJwt();
    public A withAccessTokenIsJwt(boolean accessTokenIsJwt);
    public java.lang.Boolean hasAccessTokenIsJwt();
      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public interface ClientSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.GenericSecretSourceFluent<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<N>> {

            public N and();
            public N endClientSecret();    }


      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public interface AccessTokenNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.GenericSecretSourceFluent<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<N>> {

            public N and();
            public N endAccessToken();    }


      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public interface RefreshTokenNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.GenericSecretSourceFluent<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<N>> {

            public N and();
            public N endRefreshToken();    }


      
  /**
   * Represents a certificate inside a Secret
   */
  public interface TlsTrustedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.CertSecretSourceFluent<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>> {

            public N and();
            public N endTlsTrustedCertificate();    }


}
