package io.strimzi.api.kafka.model.authentication;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.CertSecretSource;

  
  /**
   * Configures the Kafka client authentication using SASl OAUTHBEARER mechanism in client based components
   */
  public class KafkaClientAuthenticationOAuthFluentImpl<A extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent<A> {

    private java.lang.String clientId;
    private java.lang.String scope;
    private java.lang.String audience;
    private java.lang.String tokenEndpointUri;
    private java.lang.Integer connectTimeoutSeconds;
    private java.lang.Integer readTimeoutSeconds;
    private io.strimzi.api.kafka.model.GenericSecretSourceBuilder clientSecret;
    private io.strimzi.api.kafka.model.GenericSecretSourceBuilder accessToken;
    private io.strimzi.api.kafka.model.GenericSecretSourceBuilder refreshToken;
    private java.util.List<io.strimzi.api.kafka.model.CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private int maxTokenExpirySeconds;
    private boolean accessTokenIsJwt;

    public KafkaClientAuthenticationOAuthFluentImpl() {
    }

    public KafkaClientAuthenticationOAuthFluentImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth instance) {
        this.withClientId(instance.getClientId());
        
        this.withScope(instance.getScope());
        
        this.withAudience(instance.getAudience());
        
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        
        this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        
        this.withClientSecret(instance.getClientSecret());
        
        this.withAccessToken(instance.getAccessToken());
        
        this.withRefreshToken(instance.getRefreshToken());
        
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
        
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
    }

    public java.lang.String getClientId() {
        return this.clientId;
    }

    public A withClientId(java.lang.String clientId) {
        this.clientId=clientId; return (A) this;
    }

    public java.lang.Boolean hasClientId() {
        return this.clientId != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withClientId instead.
     */
        public A withNewClientId(java.lang.String original) {
        return (A)withClientId(new String(original));
    }

    public java.lang.String getScope() {
        return this.scope;
    }

    public A withScope(java.lang.String scope) {
        this.scope=scope; return (A) this;
    }

    public java.lang.Boolean hasScope() {
        return this.scope != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withScope instead.
     */
        public A withNewScope(java.lang.String original) {
        return (A)withScope(new String(original));
    }

    public java.lang.String getAudience() {
        return this.audience;
    }

    public A withAudience(java.lang.String audience) {
        this.audience=audience; return (A) this;
    }

    public java.lang.Boolean hasAudience() {
        return this.audience != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAudience instead.
     */
        public A withNewAudience(java.lang.String original) {
        return (A)withAudience(new String(original));
    }

    public java.lang.String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(java.lang.String tokenEndpointUri) {
        this.tokenEndpointUri=tokenEndpointUri; return (A) this;
    }

    public java.lang.Boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTokenEndpointUri instead.
     */
        public A withNewTokenEndpointUri(java.lang.String original) {
        return (A)withTokenEndpointUri(new String(original));
    }

    public java.lang.Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public A withConnectTimeoutSeconds(java.lang.Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds=connectTimeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds != null;
    }

    public java.lang.Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public A withReadTimeoutSeconds(java.lang.Integer readTimeoutSeconds) {
        this.readTimeoutSeconds=readTimeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasReadTimeoutSeconds() {
        return this.readTimeoutSeconds != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.GenericSecretSource getClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public io.strimzi.api.kafka.model.GenericSecretSource buildClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(io.strimzi.api.kafka.model.GenericSecretSource clientSecret) {
        _visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret!=null){ this.clientSecret= new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public java.lang.Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret() {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.ClientSecretNestedImpl();
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.ClientSecretNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret() {
        return withNewClientSecretLike(getClientSecret());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new io.strimzi.api.kafka.model.GenericSecretSourceBuilder().build());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAccessToken instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.GenericSecretSource getAccessToken() {
        return this.accessToken!=null?this.accessToken.build():null;
    }

    public io.strimzi.api.kafka.model.GenericSecretSource buildAccessToken() {
        return this.accessToken!=null?this.accessToken.build():null;
    }

    public A withAccessToken(io.strimzi.api.kafka.model.GenericSecretSource accessToken) {
        _visitables.get("accessToken").remove(this.accessToken);
        if (accessToken!=null){ this.accessToken= new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(accessToken); _visitables.get("accessToken").add(this.accessToken);} return (A) this;
    }

    public java.lang.Boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessToken() {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.AccessTokenNestedImpl();
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessTokenLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.AccessTokenNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editAccessToken() {
        return withNewAccessTokenLike(getAccessToken());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessToken() {
        return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): new io.strimzi.api.kafka.model.GenericSecretSourceBuilder().build());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessTokenLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return withNewAccessTokenLike(getAccessToken() != null ? getAccessToken(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRefreshToken instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.GenericSecretSource getRefreshToken() {
        return this.refreshToken!=null?this.refreshToken.build():null;
    }

    public io.strimzi.api.kafka.model.GenericSecretSource buildRefreshToken() {
        return this.refreshToken!=null?this.refreshToken.build():null;
    }

    public A withRefreshToken(io.strimzi.api.kafka.model.GenericSecretSource refreshToken) {
        _visitables.get("refreshToken").remove(this.refreshToken);
        if (refreshToken!=null){ this.refreshToken= new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(refreshToken); _visitables.get("refreshToken").add(this.refreshToken);} return (A) this;
    }

    public java.lang.Boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshToken() {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.RefreshTokenNestedImpl();
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshTokenLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.RefreshTokenNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editRefreshToken() {
        return withNewRefreshTokenLike(getRefreshToken());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshToken() {
        return withNewRefreshTokenLike(getRefreshToken() != null ? getRefreshToken(): new io.strimzi.api.kafka.model.GenericSecretSourceBuilder().build());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshTokenLike(io.strimzi.api.kafka.model.GenericSecretSource item) {
        return withNewRefreshTokenLike(getRefreshToken() != null ? getRefreshToken(): item);
    }

    public A addToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(index >= 0 ? index : _visitables.get("tlsTrustedCertificates").size(), builder);this.tlsTrustedCertificates.add(index >= 0 ? index : tlsTrustedCertificates.size(), builder); return (A)this;
    }

    public A setToTlsTrustedCertificates(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("tlsTrustedCertificates").size()) { _visitables.get("tlsTrustedCertificates").add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder);}
        if (index < 0 || index >= tlsTrustedCertificates.size()) { tlsTrustedCertificates.add(builder); } else { tlsTrustedCertificates.set(index, builder);}
         return (A)this;
    }

    public A addToTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>();}
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... items) {
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTlsTrustedCertificates(java.util.Collection<io.strimzi.api.kafka.model.CertSecretSource> items) {
        for (io.strimzi.api.kafka.model.CertSecretSource item : items) {io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTlsTrustedCertificates(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        if (tlsTrustedCertificates == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
        final List visitables = _visitables.get("tlsTrustedCertificates");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.CertSecretSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> getTlsTrustedCertificates() {
        return build(tlsTrustedCertificates);
    }

    public java.util.List<io.strimzi.api.kafka.model.CertSecretSource> buildTlsTrustedCertificates() {
        return build(tlsTrustedCertificates);
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.CertSecretSource buildMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTlsTrustedCertificates(java.util.List<io.strimzi.api.kafka.model.CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);}
        if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new java.util.ArrayList<io.strimzi.api.kafka.model.CertSecretSourceBuilder>(); for (io.strimzi.api.kafka.model.CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
    }

    public A withTlsTrustedCertificates(io.strimzi.api.kafka.model.CertSecretSource... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear();}
        if (tlsTrustedCertificates != null) {for (io.strimzi.api.kafka.model.CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
    }

    public java.lang.Boolean hasTlsTrustedCertificates() {
        return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.TlsTrustedCertificatesNestedImpl();
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(io.strimzi.api.kafka.model.CertSecretSource item) {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.TlsTrustedCertificatesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl.TlsTrustedCertificatesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = tlsTrustedCertificates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(java.util.function.Predicate<io.strimzi.api.kafka.model.CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tlsTrustedCertificates.size();i++) { 
        if (predicate.test(tlsTrustedCertificates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
    }

    public java.lang.Boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    public int getMaxTokenExpirySeconds() {
        return this.maxTokenExpirySeconds;
    }

    public A withMaxTokenExpirySeconds(int maxTokenExpirySeconds) {
        this.maxTokenExpirySeconds=maxTokenExpirySeconds; return (A) this;
    }

    public java.lang.Boolean hasMaxTokenExpirySeconds() {
        return true;
    }

    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt=accessTokenIsJwt; return (A) this;
    }

    public java.lang.Boolean hasAccessTokenIsJwt() {
        return true;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaClientAuthenticationOAuthFluentImpl that = (KafkaClientAuthenticationOAuthFluentImpl) o;
        if (clientId != null ? !clientId.equals(that.clientId) :that.clientId != null) return false;
        if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
        if (audience != null ? !audience.equals(that.audience) :that.audience != null) return false;
        if (tokenEndpointUri != null ? !tokenEndpointUri.equals(that.tokenEndpointUri) :that.tokenEndpointUri != null) return false;
        if (connectTimeoutSeconds != null ? !connectTimeoutSeconds.equals(that.connectTimeoutSeconds) :that.connectTimeoutSeconds != null) return false;
        if (readTimeoutSeconds != null ? !readTimeoutSeconds.equals(that.readTimeoutSeconds) :that.readTimeoutSeconds != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
        if (accessToken != null ? !accessToken.equals(that.accessToken) :that.accessToken != null) return false;
        if (refreshToken != null ? !refreshToken.equals(that.refreshToken) :that.refreshToken != null) return false;
        if (tlsTrustedCertificates != null ? !tlsTrustedCertificates.equals(that.tlsTrustedCertificates) :that.tlsTrustedCertificates != null) return false;
        if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
        if (maxTokenExpirySeconds != that.maxTokenExpirySeconds) return false;
        if (accessTokenIsJwt != that.accessTokenIsJwt) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clientId,  scope,  audience,  tokenEndpointUri,  connectTimeoutSeconds,  readTimeoutSeconds,  clientSecret,  accessToken,  refreshToken,  tlsTrustedCertificates,  disableTlsHostnameVerification,  maxTokenExpirySeconds,  accessTokenIsJwt,  super.hashCode());
    }

      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public class ClientSecretNestedImpl<N> extends io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<N>> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder;

            ClientSecretNestedImpl(io.strimzi.api.kafka.model.GenericSecretSource item) {
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this, item);
                        
            }

            ClientSecretNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClientAuthenticationOAuthFluentImpl.this.withClientSecret(builder.build());
            }

            public N endClientSecret() {
                return and();
            }
    }


      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public class AccessTokenNestedImpl<N> extends io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<N>> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.AccessTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder;

            AccessTokenNestedImpl(io.strimzi.api.kafka.model.GenericSecretSource item) {
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this, item);
                        
            }

            AccessTokenNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClientAuthenticationOAuthFluentImpl.this.withAccessToken(builder.build());
            }

            public N endAccessToken() {
                return and();
            }
    }


      
  /**
   * Represents a generic secret inside a Kubernetes Secret
   */
  public class RefreshTokenNestedImpl<N> extends io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<N>> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.GenericSecretSourceBuilder builder;

            RefreshTokenNestedImpl(io.strimzi.api.kafka.model.GenericSecretSource item) {
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this, item);
                        
            }

            RefreshTokenNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.GenericSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClientAuthenticationOAuthFluentImpl.this.withRefreshToken(builder.build());
            }

            public N endRefreshToken() {
                return and();
            }
    }


      
  /**
   * Represents a certificate inside a Secret
   */
  public class TlsTrustedCertificatesNestedImpl<N> extends io.strimzi.api.kafka.model.CertSecretSourceFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CertSecretSourceBuilder builder;
        private final int index;

            TlsTrustedCertificatesNestedImpl(int index,io.strimzi.api.kafka.model.CertSecretSource item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(this, item);
                        
            }

            TlsTrustedCertificatesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.CertSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClientAuthenticationOAuthFluentImpl.this.setToTlsTrustedCertificates(index,builder.build());
            }

            public N endTlsTrustedCertificate() {
                return and();
            }
    }


}
