package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the Kafka client authentication using SASL PLAIN in client based components
   */
  public class KafkaClientAuthenticationPlainBuilder extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder> {

    io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaClientAuthenticationPlainBuilder() {
        this(true);
    }

    public KafkaClientAuthenticationPlainBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaClientAuthenticationPlain(), validationEnabled);
    }

    public KafkaClientAuthenticationPlainBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaClientAuthenticationPlainBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaClientAuthenticationPlain(), validationEnabled);
    }

    public KafkaClientAuthenticationPlainBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain instance) {
        this(fluent, instance, true);
    }

    public KafkaClientAuthenticationPlainBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUsername(instance.getUsername());
        
        fluent.withPasswordSecret(instance.getPasswordSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationPlainBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain instance) {
        this(instance,true);
    }

    public KafkaClientAuthenticationPlainBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUsername(instance.getUsername());
        
        this.withPasswordSecret(instance.getPasswordSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain build() {
        KafkaClientAuthenticationPlain buildable = new KafkaClientAuthenticationPlain();
        buildable.setUsername(fluent.getUsername());
        buildable.setPasswordSecret(fluent.getPasswordSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaClientAuthenticationPlainBuilder that = (KafkaClientAuthenticationPlainBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
