package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_256 in client based components
   */
  public class KafkaClientAuthenticationScramSha256Builder extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256FluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Builder> {

    io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaClientAuthenticationScramSha256Builder() {
        this(true);
    }

    public KafkaClientAuthenticationScramSha256Builder(java.lang.Boolean validationEnabled) {
        this(new KafkaClientAuthenticationScramSha256(), validationEnabled);
    }

    public KafkaClientAuthenticationScramSha256Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaClientAuthenticationScramSha256Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaClientAuthenticationScramSha256(), validationEnabled);
    }

    public KafkaClientAuthenticationScramSha256Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 instance) {
        this(fluent, instance, true);
    }

    public KafkaClientAuthenticationScramSha256Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUsername(instance.getUsername());
        
        fluent.withPasswordSecret(instance.getPasswordSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationScramSha256Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 instance) {
        this(instance,true);
    }

    public KafkaClientAuthenticationScramSha256Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUsername(instance.getUsername());
        
        this.withPasswordSecret(instance.getPasswordSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256 build() {
        KafkaClientAuthenticationScramSha256 buildable = new KafkaClientAuthenticationScramSha256();
        buildable.setUsername(fluent.getUsername());
        buildable.setPasswordSecret(fluent.getPasswordSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaClientAuthenticationScramSha256Builder that = (KafkaClientAuthenticationScramSha256Builder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
