package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_512 in client based components
   */
  public class KafkaClientAuthenticationScramSha512Builder extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder> {

    io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaClientAuthenticationScramSha512Builder() {
        this(true);
    }

    public KafkaClientAuthenticationScramSha512Builder(java.lang.Boolean validationEnabled) {
        this(new KafkaClientAuthenticationScramSha512(), validationEnabled);
    }

    public KafkaClientAuthenticationScramSha512Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaClientAuthenticationScramSha512Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaClientAuthenticationScramSha512(), validationEnabled);
    }

    public KafkaClientAuthenticationScramSha512Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 instance) {
        this(fluent, instance, true);
    }

    public KafkaClientAuthenticationScramSha512Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withUsername(instance.getUsername());
        
        fluent.withPasswordSecret(instance.getPasswordSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationScramSha512Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 instance) {
        this(instance,true);
    }

    public KafkaClientAuthenticationScramSha512Builder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withUsername(instance.getUsername());
        
        this.withPasswordSecret(instance.getPasswordSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 build() {
        KafkaClientAuthenticationScramSha512 buildable = new KafkaClientAuthenticationScramSha512();
        buildable.setUsername(fluent.getUsername());
        buildable.setPasswordSecret(fluent.getPasswordSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaClientAuthenticationScramSha512Builder that = (KafkaClientAuthenticationScramSha512Builder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
