package io.strimzi.api.kafka.model.authentication;

import io.strimzi.api.kafka.model.PasswordSecretSourceFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.PasswordSecretSource;
import java.lang.String;
import io.strimzi.api.kafka.model.PasswordSecretSourceBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the Kafka client authentication using SASL SCRAM_SHA_512 in client based components
   */
  public class KafkaClientAuthenticationScramSha512FluentImpl<A extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent<A> {

    private java.lang.String username;
    private io.strimzi.api.kafka.model.PasswordSecretSourceBuilder passwordSecret;

    public KafkaClientAuthenticationScramSha512FluentImpl() {
    }

    public KafkaClientAuthenticationScramSha512FluentImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512 instance) {
        this.withUsername(instance.getUsername());
        
        this.withPasswordSecret(instance.getPasswordSecret());
    }

    public java.lang.String getUsername() {
        return this.username;
    }

    public A withUsername(java.lang.String username) {
        this.username=username; return (A) this;
    }

    public java.lang.Boolean hasUsername() {
        return this.username != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUsername instead.
     */
        public A withNewUsername(java.lang.String original) {
        return (A)withUsername(new String(original));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPasswordSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.PasswordSecretSource getPasswordSecret() {
        return this.passwordSecret!=null?this.passwordSecret.build():null;
    }

    public io.strimzi.api.kafka.model.PasswordSecretSource buildPasswordSecret() {
        return this.passwordSecret!=null?this.passwordSecret.build():null;
    }

    public A withPasswordSecret(io.strimzi.api.kafka.model.PasswordSecretSource passwordSecret) {
        _visitables.get("passwordSecret").remove(this.passwordSecret);
        if (passwordSecret!=null){ this.passwordSecret= new io.strimzi.api.kafka.model.PasswordSecretSourceBuilder(passwordSecret); _visitables.get("passwordSecret").add(this.passwordSecret);} return (A) this;
    }

    public java.lang.Boolean hasPasswordSecret() {
        return this.passwordSecret != null;
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent.PasswordSecretNested<A> withNewPasswordSecret() {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl.PasswordSecretNestedImpl();
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent.PasswordSecretNested<A> withNewPasswordSecretLike(io.strimzi.api.kafka.model.PasswordSecretSource item) {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl.PasswordSecretNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent.PasswordSecretNested<A> editPasswordSecret() {
        return withNewPasswordSecretLike(getPasswordSecret());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent.PasswordSecretNested<A> editOrNewPasswordSecret() {
        return withNewPasswordSecretLike(getPasswordSecret() != null ? getPasswordSecret(): new io.strimzi.api.kafka.model.PasswordSecretSourceBuilder().build());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent.PasswordSecretNested<A> editOrNewPasswordSecretLike(io.strimzi.api.kafka.model.PasswordSecretSource item) {
        return withNewPasswordSecretLike(getPasswordSecret() != null ? getPasswordSecret(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaClientAuthenticationScramSha512FluentImpl that = (KafkaClientAuthenticationScramSha512FluentImpl) o;
        if (username != null ? !username.equals(that.username) :that.username != null) return false;
        if (passwordSecret != null ? !passwordSecret.equals(that.passwordSecret) :that.passwordSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(username,  passwordSecret,  super.hashCode());
    }

      
  /**
   * Represents a password inside a Secret
   */
  public class PasswordSecretNestedImpl<N> extends io.strimzi.api.kafka.model.PasswordSecretSourceFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent.PasswordSecretNested<N>> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent.PasswordSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.PasswordSecretSourceBuilder builder;

            PasswordSecretNestedImpl(io.strimzi.api.kafka.model.PasswordSecretSource item) {
                this.builder = new io.strimzi.api.kafka.model.PasswordSecretSourceBuilder(this, item);
                        
            }

            PasswordSecretNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.PasswordSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClientAuthenticationScramSha512FluentImpl.this.withPasswordSecret(builder.build());
            }

            public N endPasswordSecret() {
                return and();
            }
    }


}
