package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures the Kafka client authentication using TLS client authentication in client based components
   */
  public class KafkaClientAuthenticationTlsBuilder extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder> {

    io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaClientAuthenticationTlsBuilder() {
        this(true);
    }

    public KafkaClientAuthenticationTlsBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaClientAuthenticationTls(), validationEnabled);
    }

    public KafkaClientAuthenticationTlsBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaClientAuthenticationTlsBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaClientAuthenticationTls(), validationEnabled);
    }

    public KafkaClientAuthenticationTlsBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls instance) {
        this(fluent, instance, true);
    }

    public KafkaClientAuthenticationTlsBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<?> fluent,io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCertificateAndKey(instance.getCertificateAndKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationTlsBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls instance) {
        this(instance,true);
    }

    public KafkaClientAuthenticationTlsBuilder(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCertificateAndKey(instance.getCertificateAndKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls build() {
        KafkaClientAuthenticationTls buildable = new KafkaClientAuthenticationTls();
        buildable.setCertificateAndKey(fluent.getCertificateAndKey());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaClientAuthenticationTlsBuilder that = (KafkaClientAuthenticationTlsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
