package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.CertAndKeySecretSource;

  
  /**
   * Configures the Kafka client authentication using TLS client authentication in client based components
   */
  public class KafkaClientAuthenticationTlsFluentImpl<A extends io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent<A> {

    private io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder certificateAndKey;

    public KafkaClientAuthenticationTlsFluentImpl() {
    }

    public KafkaClientAuthenticationTlsFluentImpl(io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls instance) {
        this.withCertificateAndKey(instance.getCertificateAndKey());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCertificateAndKey instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.CertAndKeySecretSource getCertificateAndKey() {
        return this.certificateAndKey!=null?this.certificateAndKey.build():null;
    }

    public io.strimzi.api.kafka.model.CertAndKeySecretSource buildCertificateAndKey() {
        return this.certificateAndKey!=null?this.certificateAndKey.build():null;
    }

    public A withCertificateAndKey(io.strimzi.api.kafka.model.CertAndKeySecretSource certificateAndKey) {
        _visitables.get("certificateAndKey").remove(this.certificateAndKey);
        if (certificateAndKey!=null){ this.certificateAndKey= new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder(certificateAndKey); _visitables.get("certificateAndKey").add(this.certificateAndKey);} return (A) this;
    }

    public java.lang.Boolean hasCertificateAndKey() {
        return this.certificateAndKey != null;
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> withNewCertificateAndKey() {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl.CertificateAndKeyNestedImpl();
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> withNewCertificateAndKeyLike(io.strimzi.api.kafka.model.CertAndKeySecretSource item) {
        return new io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl.CertificateAndKeyNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> editCertificateAndKey() {
        return withNewCertificateAndKeyLike(getCertificateAndKey());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> editOrNewCertificateAndKey() {
        return withNewCertificateAndKeyLike(getCertificateAndKey() != null ? getCertificateAndKey(): new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder().build());
    }

    public io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> editOrNewCertificateAndKeyLike(io.strimzi.api.kafka.model.CertAndKeySecretSource item) {
        return withNewCertificateAndKeyLike(getCertificateAndKey() != null ? getCertificateAndKey(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaClientAuthenticationTlsFluentImpl that = (KafkaClientAuthenticationTlsFluentImpl) o;
        if (certificateAndKey != null ? !certificateAndKey.equals(that.certificateAndKey) :that.certificateAndKey != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(certificateAndKey,  super.hashCode());
    }

      
  /**
   * Represents a certificate and private key pair inside a Secret
   */
  public class CertificateAndKeyNestedImpl<N> extends io.strimzi.api.kafka.model.CertAndKeySecretSourceFluentImpl<io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<N>> implements io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder builder;

            CertificateAndKeyNestedImpl(io.strimzi.api.kafka.model.CertAndKeySecretSource item) {
                this.builder = new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder(this, item);
                        
            }

            CertificateAndKeyNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClientAuthenticationTlsFluentImpl.this.withCertificateAndKey(builder.build());
            }

            public N endCertificateAndKey() {
                return and();
            }
    }


}
