package io.strimzi.api.kafka.model.balancing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of the Cruise Control broker capacity settings. Since the Kafka brokers
   * in Strimzi are homogeneous, the capacity values for each resource will be
   * used for every broker.
   */
  public class BrokerCapacityBuilder extends io.strimzi.api.kafka.model.balancing.BrokerCapacityFluentImpl<io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.balancing.BrokerCapacity,io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder> {

    io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BrokerCapacityBuilder() {
        this(true);
    }

    public BrokerCapacityBuilder(java.lang.Boolean validationEnabled) {
        this(new BrokerCapacity(), validationEnabled);
    }

    public BrokerCapacityBuilder(io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent<?> fluent) {
        this(fluent, true);
    }

    public BrokerCapacityBuilder(io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BrokerCapacity(), validationEnabled);
    }

    public BrokerCapacityBuilder(io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent<?> fluent,io.strimzi.api.kafka.model.balancing.BrokerCapacity instance) {
        this(fluent, instance, true);
    }

    public BrokerCapacityBuilder(io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent<?> fluent,io.strimzi.api.kafka.model.balancing.BrokerCapacity instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDisk(instance.getDisk());
        
        fluent.withCpuUtilization(instance.getCpuUtilization());
        
        fluent.withInboundNetwork(instance.getInboundNetwork());
        
        fluent.withOutboundNetwork(instance.getOutboundNetwork());
        
        this.validationEnabled = validationEnabled; 
    }

    public BrokerCapacityBuilder(io.strimzi.api.kafka.model.balancing.BrokerCapacity instance) {
        this(instance,true);
    }

    public BrokerCapacityBuilder(io.strimzi.api.kafka.model.balancing.BrokerCapacity instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDisk(instance.getDisk());
        
        this.withCpuUtilization(instance.getCpuUtilization());
        
        this.withInboundNetwork(instance.getInboundNetwork());
        
        this.withOutboundNetwork(instance.getOutboundNetwork());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.balancing.BrokerCapacity build() {
        BrokerCapacity buildable = new BrokerCapacity();
        buildable.setDisk(fluent.getDisk());
        buildable.setCpuUtilization(fluent.getCpuUtilization());
        buildable.setInboundNetwork(fluent.getInboundNetwork());
        buildable.setOutboundNetwork(fluent.getOutboundNetwork());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BrokerCapacityBuilder that = (BrokerCapacityBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
