package io.strimzi.api.kafka.model.balancing;

import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Representation of the Cruise Control broker capacity settings. Since the Kafka brokers
   * in Strimzi are homogeneous, the capacity values for each resource will be
   * used for every broker.
   */
  public interface BrokerCapacityFluent<A extends io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getDisk();
    public A withDisk(java.lang.String disk);
    public java.lang.Boolean hasDisk();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDisk instead.
     */
        public A withNewDisk(java.lang.String original);
    public java.lang.Integer getCpuUtilization();
    public A withCpuUtilization(java.lang.Integer cpuUtilization);
    public java.lang.Boolean hasCpuUtilization();
    public java.lang.String getInboundNetwork();
    public A withInboundNetwork(java.lang.String inboundNetwork);
    public java.lang.Boolean hasInboundNetwork();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withInboundNetwork instead.
     */
        public A withNewInboundNetwork(java.lang.String original);
    public java.lang.String getOutboundNetwork();
    public A withOutboundNetwork(java.lang.String outboundNetwork);
    public java.lang.Boolean hasOutboundNetwork();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withOutboundNetwork instead.
     */
        public A withNewOutboundNetwork(java.lang.String original);
}
