package io.strimzi.api.kafka.model.balancing;

import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

  
  /**
   * Representation of the Cruise Control broker capacity settings. Since the Kafka brokers
   * in Strimzi are homogeneous, the capacity values for each resource will be
   * used for every broker.
   */
  public class BrokerCapacityFluentImpl<A extends io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.balancing.BrokerCapacityFluent<A> {

    private java.lang.String disk;
    private java.lang.Integer cpuUtilization;
    private java.lang.String inboundNetwork;
    private java.lang.String outboundNetwork;

    public BrokerCapacityFluentImpl() {
    }

    public BrokerCapacityFluentImpl(io.strimzi.api.kafka.model.balancing.BrokerCapacity instance) {
        this.withDisk(instance.getDisk());
        
        this.withCpuUtilization(instance.getCpuUtilization());
        
        this.withInboundNetwork(instance.getInboundNetwork());
        
        this.withOutboundNetwork(instance.getOutboundNetwork());
    }

    public java.lang.String getDisk() {
        return this.disk;
    }

    public A withDisk(java.lang.String disk) {
        this.disk=disk; return (A) this;
    }

    public java.lang.Boolean hasDisk() {
        return this.disk != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDisk instead.
     */
        public A withNewDisk(java.lang.String original) {
        return (A)withDisk(new String(original));
    }

    public java.lang.Integer getCpuUtilization() {
        return this.cpuUtilization;
    }

    public A withCpuUtilization(java.lang.Integer cpuUtilization) {
        this.cpuUtilization=cpuUtilization; return (A) this;
    }

    public java.lang.Boolean hasCpuUtilization() {
        return this.cpuUtilization != null;
    }

    public java.lang.String getInboundNetwork() {
        return this.inboundNetwork;
    }

    public A withInboundNetwork(java.lang.String inboundNetwork) {
        this.inboundNetwork=inboundNetwork; return (A) this;
    }

    public java.lang.Boolean hasInboundNetwork() {
        return this.inboundNetwork != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withInboundNetwork instead.
     */
        public A withNewInboundNetwork(java.lang.String original) {
        return (A)withInboundNetwork(new String(original));
    }

    public java.lang.String getOutboundNetwork() {
        return this.outboundNetwork;
    }

    public A withOutboundNetwork(java.lang.String outboundNetwork) {
        this.outboundNetwork=outboundNetwork; return (A) this;
    }

    public java.lang.Boolean hasOutboundNetwork() {
        return this.outboundNetwork != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withOutboundNetwork instead.
     */
        public A withNewOutboundNetwork(java.lang.String original) {
        return (A)withOutboundNetwork(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BrokerCapacityFluentImpl that = (BrokerCapacityFluentImpl) o;
        if (disk != null ? !disk.equals(that.disk) :that.disk != null) return false;
        if (cpuUtilization != null ? !cpuUtilization.equals(that.cpuUtilization) :that.cpuUtilization != null) return false;
        if (inboundNetwork != null ? !inboundNetwork.equals(that.inboundNetwork) :that.inboundNetwork != null) return false;
        if (outboundNetwork != null ? !outboundNetwork.equals(that.outboundNetwork) :that.outboundNetwork != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(disk,  cpuUtilization,  inboundNetwork,  outboundNetwork,  super.hashCode());
    }

}
