package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation a connector plugin available in the Kafka Connect deployment
   */
  public class ConnectorPluginBuilder extends io.strimzi.api.kafka.model.connect.ConnectorPluginFluentImpl<io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.ConnectorPlugin,io.strimzi.api.kafka.model.connect.ConnectorPluginBuilder> {

    io.strimzi.api.kafka.model.connect.ConnectorPluginFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ConnectorPluginBuilder() {
        this(true);
    }

    public ConnectorPluginBuilder(java.lang.Boolean validationEnabled) {
        this(new ConnectorPlugin(), validationEnabled);
    }

    public ConnectorPluginBuilder(io.strimzi.api.kafka.model.connect.ConnectorPluginFluent<?> fluent) {
        this(fluent, true);
    }

    public ConnectorPluginBuilder(io.strimzi.api.kafka.model.connect.ConnectorPluginFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ConnectorPlugin(), validationEnabled);
    }

    public ConnectorPluginBuilder(io.strimzi.api.kafka.model.connect.ConnectorPluginFluent<?> fluent,io.strimzi.api.kafka.model.connect.ConnectorPlugin instance) {
        this(fluent, instance, true);
    }

    public ConnectorPluginBuilder(io.strimzi.api.kafka.model.connect.ConnectorPluginFluent<?> fluent,io.strimzi.api.kafka.model.connect.ConnectorPlugin instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConnectorClass(instance.getConnectorClass());
        
        fluent.withType(instance.getType());
        
        fluent.withVersion(instance.getVersion());
        
        this.validationEnabled = validationEnabled; 
    }

    public ConnectorPluginBuilder(io.strimzi.api.kafka.model.connect.ConnectorPlugin instance) {
        this(instance,true);
    }

    public ConnectorPluginBuilder(io.strimzi.api.kafka.model.connect.ConnectorPlugin instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConnectorClass(instance.getConnectorClass());
        
        this.withType(instance.getType());
        
        this.withVersion(instance.getVersion());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.ConnectorPlugin build() {
        ConnectorPlugin buildable = new ConnectorPlugin();
        buildable.setConnectorClass(fluent.getConnectorClass());
        buildable.setType(fluent.getType());
        buildable.setVersion(fluent.getVersion());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConnectorPluginBuilder that = (ConnectorPluginBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
