package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for external configuration for Kafka Connect connectors passed from Secrets or ConfigMaps
   */
  public class ExternalConfigurationBuilder extends io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl<io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.ExternalConfiguration,io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder> {

    io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExternalConfigurationBuilder() {
        this(true);
    }

    public ExternalConfigurationBuilder(java.lang.Boolean validationEnabled) {
        this(new ExternalConfiguration(), validationEnabled);
    }

    public ExternalConfigurationBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalConfigurationBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExternalConfiguration(), validationEnabled);
    }

    public ExternalConfigurationBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent<?> fluent,io.strimzi.api.kafka.model.connect.ExternalConfiguration instance) {
        this(fluent, instance, true);
    }

    public ExternalConfigurationBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent<?> fluent,io.strimzi.api.kafka.model.connect.ExternalConfiguration instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withEnv(instance.getEnv());
        
        fluent.withVolumes(instance.getVolumes());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationBuilder(io.strimzi.api.kafka.model.connect.ExternalConfiguration instance) {
        this(instance,true);
    }

    public ExternalConfigurationBuilder(io.strimzi.api.kafka.model.connect.ExternalConfiguration instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withEnv(instance.getEnv());
        
        this.withVolumes(instance.getVolumes());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfiguration build() {
        ExternalConfiguration buildable = new ExternalConfiguration();
        buildable.setEnv(fluent.getEnv());
        buildable.setVolumes(fluent.getVolumes());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalConfigurationBuilder that = (ExternalConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
