package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for environment variables which will be passed to Kafka Connect
   */
  public class ExternalConfigurationEnvBuilder extends io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluentImpl<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> {

    io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExternalConfigurationEnvBuilder() {
        this(true);
    }

    public ExternalConfigurationEnvBuilder(java.lang.Boolean validationEnabled) {
        this(new ExternalConfigurationEnv(), validationEnabled);
    }

    public ExternalConfigurationEnvBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalConfigurationEnvBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExternalConfigurationEnv(), validationEnabled);
    }

    public ExternalConfigurationEnvBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluent<?> fluent,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv instance) {
        this(fluent, instance, true);
    }

    public ExternalConfigurationEnvBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluent<?> fluent,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withValueFrom(instance.getValueFrom());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationEnvBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv instance) {
        this(instance,true);
    }

    public ExternalConfigurationEnvBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withValueFrom(instance.getValueFrom());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv build() {
        ExternalConfigurationEnv buildable = new ExternalConfigurationEnv();
        buildable.setName(fluent.getName());
        buildable.setValueFrom(fluent.getValueFrom());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalConfigurationEnvBuilder that = (ExternalConfigurationEnvBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
