package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for environment variables which will be passed to Kafka Connect
   */
  public class ExternalConfigurationEnvVarSourceBuilder extends io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceFluentImpl<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSource,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceBuilder> {

    io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExternalConfigurationEnvVarSourceBuilder() {
        this(true);
    }

    public ExternalConfigurationEnvVarSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new ExternalConfigurationEnvVarSource(), validationEnabled);
    }

    public ExternalConfigurationEnvVarSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalConfigurationEnvVarSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExternalConfigurationEnvVarSource(), validationEnabled);
    }

    public ExternalConfigurationEnvVarSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceFluent<?> fluent,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSource instance) {
        this(fluent, instance, true);
    }

    public ExternalConfigurationEnvVarSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceFluent<?> fluent,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSecretKeyRef(instance.getSecretKeyRef());
        
        fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationEnvVarSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSource instance) {
        this(instance,true);
    }

    public ExternalConfigurationEnvVarSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSecretKeyRef(instance.getSecretKeyRef());
        
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSource build() {
        ExternalConfigurationEnvVarSource buildable = new ExternalConfigurationEnvVarSource();
        buildable.setSecretKeyRef(fluent.getSecretKeyRef());
        buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalConfigurationEnvVarSourceBuilder that = (ExternalConfigurationEnvVarSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
