package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

  
  /**
   * Representation for environment variables which will be passed to Kafka Connect
   */
  public class ExternalConfigurationEnvVarSourceFluentImpl<A extends io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSourceFluent<A> {

    private io.fabric8.kubernetes.api.model.SecretKeySelector secretKeyRef;
    private io.fabric8.kubernetes.api.model.ConfigMapKeySelector configMapKeyRef;

    public ExternalConfigurationEnvVarSourceFluentImpl() {
    }

    public ExternalConfigurationEnvVarSourceFluentImpl(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvVarSource instance) {
        this.withSecretKeyRef(instance.getSecretKeyRef());
        
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
    }

    public io.fabric8.kubernetes.api.model.SecretKeySelector getSecretKeyRef() {
        return this.secretKeyRef;
    }

    public A withSecretKeyRef(io.fabric8.kubernetes.api.model.SecretKeySelector secretKeyRef) {
        this.secretKeyRef=secretKeyRef; return (A) this;
    }

    public java.lang.Boolean hasSecretKeyRef() {
        return this.secretKeyRef != null;
    }

    public A withNewSecretKeyRef(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
        return (A)withSecretKeyRef(new SecretKeySelector(key, name, optional));
    }

    public io.fabric8.kubernetes.api.model.ConfigMapKeySelector getConfigMapKeyRef() {
        return this.configMapKeyRef;
    }

    public A withConfigMapKeyRef(io.fabric8.kubernetes.api.model.ConfigMapKeySelector configMapKeyRef) {
        this.configMapKeyRef=configMapKeyRef; return (A) this;
    }

    public java.lang.Boolean hasConfigMapKeyRef() {
        return this.configMapKeyRef != null;
    }

    public A withNewConfigMapKeyRef(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
        return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalConfigurationEnvVarSourceFluentImpl that = (ExternalConfigurationEnvVarSourceFluentImpl) o;
        if (secretKeyRef != null ? !secretKeyRef.equals(that.secretKeyRef) :that.secretKeyRef != null) return false;
        if (configMapKeyRef != null ? !configMapKeyRef.equals(that.configMapKeyRef) :that.configMapKeyRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(secretKeyRef,  configMapKeyRef,  super.hashCode());
    }

}
