package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Representation for external configuration for Kafka Connect connectors passed from Secrets or ConfigMaps
   */
  public interface ExternalConfigurationFluent<A extends io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToEnv(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item);
    public A setToEnv(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item);
    public A addToEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... items);
    public A addAllToEnv(java.util.Collection<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> items);
    public A removeFromEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... items);
    public A removeAllFromEnv(java.util.Collection<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> items);
    public A removeMatchingFromEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEnv instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> getEnv();
    public java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> buildEnv();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv buildEnv(int index);
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv buildFirstEnv();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv buildLastEnv();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv buildMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> predicate);
    public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> predicate);
    public A withEnv(java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> env);
    public A withEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... env);
    public java.lang.Boolean hasEnv();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> addNewEnv();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> addNewEnvLike(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item);
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> setNewEnvLike(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item);
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> editEnv(int index);
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> editFirstEnv();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> editLastEnv();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> editMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> predicate);
    public A addToVolumes(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item);
    public A setToVolumes(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item);
    public A addToVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... items);
    public A addAllToVolumes(java.util.Collection<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> items);
    public A removeFromVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... items);
    public A removeAllFromVolumes(java.util.Collection<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> items);
    public A removeMatchingFromVolumes(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumes instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> getVolumes();
    public java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> buildVolumes();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource buildVolume(int index);
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource buildFirstVolume();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource buildLastVolume();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource buildMatchingVolume(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> predicate);
    public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> predicate);
    public A withVolumes(java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> volumes);
    public A withVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... volumes);
    public java.lang.Boolean hasVolumes();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> addNewVolume();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> addNewVolumeLike(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item);
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> setNewVolumeLike(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item);
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> editVolume(int index);
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> editFirstVolume();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> editLastVolume();
    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> editMatchingVolume(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> predicate);
      
  /**
   * Representation for environment variables which will be passed to Kafka Connect
   */
  public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluent<io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<N>> {

            public N and();
            public N endEnv();    }


      
  /**
   * Representation for environment variables which will be passed to Kafka Connect
   */
  public interface VolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluent<io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<N>> {

            public N and();
            public N endVolume();    }


}
