package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Representation for external configuration for Kafka Connect connectors passed from Secrets or ConfigMaps
   */
  public class ExternalConfigurationFluentImpl<A extends io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent<A> {

    private java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> env;
    private java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> volumes;

    public ExternalConfigurationFluentImpl() {
    }

    public ExternalConfigurationFluentImpl(io.strimzi.api.kafka.model.connect.ExternalConfiguration instance) {
        this.withEnv(instance.getEnv());
        
        this.withVolumes(instance.getVolumes());
    }

    public A addToEnv(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder>();}
        io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
    }

    public A setToEnv(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder>();}
        io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder(item);
        if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
        if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
         return (A)this;
    }

    public A addToEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder>();}
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item : items) {io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A addAllToEnv(java.util.Collection<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder>();}
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item : items) {io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... items) {
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item : items) {io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnv(java.util.Collection<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> items) {
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item : items) {io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> predicate) {
        if (env == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> each = env.iterator();
        final List visitables = _visitables.get("env");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEnv instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> getEnv() {
        return build(env);
    }

    public java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> buildEnv() {
        return build(env);
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv buildEnv(int index) {
        return this.env.get(index).build();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv buildFirstEnv() {
        return this.env.get(0).build();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv buildLastEnv() {
        return this.env.get(env.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv buildMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> predicate) {
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> predicate) {
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder>(); for (io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item :env){ this.addToEnv(item);}} return (A) this;
    }

    public java.lang.Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> addNewEnv() {
        return new io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl.EnvNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> addNewEnvLike(io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item) {
        return new io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl.EnvNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> setNewEnvLike(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item) {
        return new io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl.EnvNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> editEnv(int index) {
        if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> editFirstEnv() {
        if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
        return setNewEnvLike(0, buildEnv(0));
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> editLastEnv() {
        int index = env.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<A> editMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder> predicate) {
        int index = -1;
        for (int i=0;i<env.size();i++) { 
        if (predicate.test(env.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public A addToVolumes(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder>();}
        io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder>();}
        io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder>();}
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item : items) {io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(java.util.Collection<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder>();}
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item : items) {io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... items) {
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item : items) {io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(java.util.Collection<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> items) {
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item : items) {io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumes(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumes instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> getVolumes() {
        return build(volumes);
    }

    public java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> buildVolumes() {
        return build(volumes);
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource buildLastVolume() {
        return this.volumes.get(volumes.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource buildMatchingVolume(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> predicate) {
        for (io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(java.util.List<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new java.util.ArrayList<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder>(); for (io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public java.lang.Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> addNewVolume() {
        return new io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl.VolumesNestedImpl();
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> addNewVolumeLike(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item) {
        return new io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl.VolumesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> setNewVolumeLike(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item) {
        return new io.strimzi.api.kafka.model.connect.ExternalConfigurationFluentImpl.VolumesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> editVolume(int index) {
        if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> editFirstVolume() {
        if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
        return setNewVolumeLike(0, buildVolume(0));
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> editLastVolume() {
        int index = volumes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<A> editMatchingVolume(java.util.function.Predicate<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumes.size();i++) { 
        if (predicate.test(volumes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ExternalConfigurationFluentImpl that = (ExternalConfigurationFluentImpl) o;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(env,  volumes,  super.hashCode());
    }

      
  /**
   * Representation for environment variables which will be passed to Kafka Connect
   */
  public class EnvNestedImpl<N> extends io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvFluentImpl<io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<N>> implements io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder builder;
        private final int index;

            EnvNestedImpl(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationEnv item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder(this, item);
                        
            }

            EnvNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationEnvBuilder(this);
                        
            }

            public N and() {
                return (N) ExternalConfigurationFluentImpl.this.setToEnv(index,builder.build());
            }

            public N endEnv() {
                return and();
            }
    }


      
  /**
   * Representation for environment variables which will be passed to Kafka Connect
   */
  public class VolumesNestedImpl<N> extends io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluentImpl<io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<N>> implements io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder builder;
        private final int index;

            VolumesNestedImpl(int index,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder(this, item);
                        
            }

            VolumesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder(this);
                        
            }

            public N and() {
                return (N) ExternalConfigurationFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endVolume() {
                return and();
            }
    }


}
