package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for environment variables which will be passed to Kafka Connect
   */
  public class ExternalConfigurationVolumeSourceBuilder extends io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluentImpl<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder> {

    io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExternalConfigurationVolumeSourceBuilder() {
        this(true);
    }

    public ExternalConfigurationVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new ExternalConfigurationVolumeSource(), validationEnabled);
    }

    public ExternalConfigurationVolumeSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalConfigurationVolumeSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExternalConfigurationVolumeSource(), validationEnabled);
    }

    public ExternalConfigurationVolumeSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluent<?> fluent,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource instance) {
        this(fluent, instance, true);
    }

    public ExternalConfigurationVolumeSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceFluent<?> fluent,io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withSecret(instance.getSecret());
        
        fluent.withConfigMap(instance.getConfigMap());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationVolumeSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource instance) {
        this(instance,true);
    }

    public ExternalConfigurationVolumeSourceBuilder(io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withSecret(instance.getSecret());
        
        this.withConfigMap(instance.getConfigMap());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource build() {
        ExternalConfigurationVolumeSource buildable = new ExternalConfigurationVolumeSource();
        buildable.setName(fluent.getName());
        buildable.setSecret(fluent.getSecret());
        buildable.setConfigMap(fluent.getConfigMap());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalConfigurationVolumeSourceBuilder that = (ExternalConfigurationVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
